function [verteilungen, versuche, abw] = pVerteilungErzeugen_neu(k_r, sigma_r, mu_r, k_b, sigma_b, mu_b, Pmean, maxPs, minPs, maxAbw, maxAbwWarn)
%Erzeugt aus gegebenen Parametern Verteilungen.

%Anzahl der zu erzeugenden Profile angeben (default: 1000, dieser Wert 
%sollte NICHT ohne Weiteres gendert werden)
nProfile = 1000;
%maximale Anzahl der Versuche, eine Verteilung zu erzeugen (die die
%durchschnittliche Leistung mglichst gut trifft) festlegen
maxVersuche = 100;

[x,y] = size(k_r);
verteilungen = cell(x,y);
versuche = nan(x,y);
abw = nan(x,y);

parfor z=1:x
    for s=1:y
        %Verteilungen erzeugen mit Parametern mit statistischen Anteilen
        [verteilungen{z,s}, versuche(z,s), abw(z,s)] = makeDist(k_r(z,s),sigma_r(z,s),mu_r(z,s),Pmean(z,s),nProfile,maxVersuche,maxAbw,maxPs(z,s),minPs(z,s));
        %Wenn dies nur mit unzulssiger Abweichung gelingt ohne stat. Ant.
        if abw(z,s) > maxAbw
            [tmp_verteilungen, tmp_versuche, tmp_abw] = makeDist(k_b(z,s),sigma_b(z,s),mu_b(z,s),Pmean(z,s),nProfile,maxVersuche,maxAbw,maxPs(z,s),minPs(z,s));
            %nur bernehmen, wenn Verbesserung
            if tmp_abw < abw(z,s)
                verteilungen{z,s} = tmp_verteilungen;
                versuche(z,s) = versuche(z,s) + tmp_versuche;
                abw(z,s) = tmp_abw;
            end
        end
        %Warnung ausgeben, wenn endgltige Abweichung ber Sollwert
        if abw(z,s) > maxAbwWarn
        disp(['Warnung: An Tag ' num2str(z) ', Zeitpunkt ' num2str(s) ...
            ' wird Warnwert (' num2str(maxAbwWarn) ...
            ') berschritten. Tatschliche Abweichung: ' num2str(abw(z,s))])
        end
    end
end
end


function [ Pvalues, d, abw] = makeDist(k, sigma, mu, meanPower, nProfile, maxVersuche, maxAbw, maxP, minP)
% disp(meanPower)
% disp(nProfile)
% disp(maxVersuche)
% disp(maxVersuche)
% disp(maxVersuche)
% disp(maxVersuche)
%verwenden, wenn eine Generalisierte Extremwertfunktion (GEV) vorliegt 
Pvalues = ones(nProfile,1); %ones, damit nachher dadurch geteilt werden kann
%mehrfach berechnen und die Werte nehmen, fr die die Durchschnittsleistung
%am besten passt
%Wenn Daten fehlen: NaN zurckgeben
if isnan(k) || isnan(sigma) || isnan(mu) || isnan(meanPower)
    Pvalues = nan(nProfile,1);
    d = nan;
    abw = nan;
else %Verteilung erzeugen
d=0;%
    while abs((mean(Pvalues)-meanPower)/meanPower)>maxAbw && d<maxVersuche %neue Verteilung, bis ausreichend nah an durchschnittlicher Vert. oder zu viele Versuche (dann beste)
        d=d+1;%
        
        %ProbDist-Objekt der Verteilung erstellen
        distr = makedist('gev', 'k', k, 'sigma', sigma, 'mu', mu);
        %"Zurechtschneiden" (damit nur realistischer Wertebereich)
        distr = truncate(distr, minP, maxP);
        %Werte der Verteilung erzeugen
        Pvalues_temp = random(distr, nProfile,1);

        %wenn Durchschnittsleistung besser als alle vorherigen -> bernehmen
        if abs(mean(Pvalues_temp)-meanPower) < abs(mean(Pvalues)-meanPower)
            Pvalues = Pvalues_temp;
            abw = abs((mean(Pvalues)-meanPower)/meanPower);
        end
    end
end
end

