function [lastverlaeufe, lastverlaeufe_neu, referenzverbraucher, gruppeneinteilungen, gruppeneinteilungen_neu] = lastVerlaeufeErstellen(days, times, verteilungen, lastwechsel, isSchaltjahr)
%erstellt aus bergebenen Leistungsverteilungen sinnvolle Lastverlufe
%einzelner Verbraucher (= die zuvor erzeugten Leistungswerte werden den
%Verbrauchern so zugewiesen, dass sich sinnvolle Lastverlufe ergeben)

%Anzahl der zu modellierenden Verbraucher (durch an Funktion bergebene
%Variable festgelegt)
nVerbraucher = size(verteilungen{1,1},1);
%Anzahl der Gruppen, in die Leistungen eingeteilt werden (durch an Funktion
%bergebene Variable festgelegt)
nGruppen = length(lastwechsel{1,2}{1,1});

smax = length(times);
    
%Folgender Abschnitt: Fr jeden Verbraucher Gruppeneinteilung im 
%Jahresverlauf bestimmen
%Array mit Gruppeneinteilungen vorbereiten
gruppeneinteilungen = nan(length(days),length(times),nVerbraucher);
%Array mit Referenzverbrauchern vorbereiten (jeder "synthetische
%Verbraucher basiert auf der hinterlegten Statistik eines gemessenen
%Verbrauchers. "Referenzverbraucher" bezeichnet den Verbraucher, dessen
%Statistik fr den jeweiligen synthetischen Verbraucher verwendet wird
referenzverbraucher = nan(nVerbraucher,1);
parfor n=1:nVerbraucher
    %Dummy gegen Warnung
    temp_uebMatr = 0;
    %Jeweiligen zugrundeliegenden ursprnglichen (gemessenen) Verbraucher
    %aus verfgbaren zufllig auswhlen.
    idx_lastwechsel = ceil(rand()*size(lastwechsel,1));
    %Jeweilige Referenzverbraucher fr sptere manuelle Auswertung speichern 
    referenzverbraucher(n,1) = idx_lastwechsel;
    %Zeitliche Unterteilung bernehmen (ist fr jeden der 
    %Referenzerbraucher unterschiedlich; Details: siehe erweiterte
    %Dokumentation)
    unterteilung = lastwechsel{idx_lastwechsel,1};
    %bergangsmatrix bernehmen, welche zum jeweiligen Zeitpunkt die
    %statistischen Eigenschaften des jew. Referenzverbrauchers enthlt
    uebergangsmatr = lastwechsel{idx_lastwechsel,2};
    
    %Array mit Gruppeneinteilung zu allen Zeitpunkten des Jahres
    %vorbereiten
    temp_gruppen = nan(length(days), length(times));
    %Zufallswerte fr bergnge ermitteln (Array mit Werten zwischen 0 und
    %1 fr jeden Zeitpunkt des Jahres
    zufallsmat = rand(length(days), length(times));
    %Startgruppe (an Neujahr direkt nach 0 Uhr) des jew. Verbrauchers zufllig bestimmen
    group = ceil(rand()*nGruppen);
    for z=1:length(days)
        if isSchaltjahr %bei Schaltjahr ist geht Winter bis Tag 80 statt 79 (20. Mrz)
            if (z>=306 && z<=366) || (z<=80 && z >=1)
                %Winter
                k=1;
            elseif (z>=136 && z<=258)
                %Sommer
                k=2;
            else
                %bergangszeit
                k=3;
            end
        else %wenn kein Schaltjahr
            if (z>=305 && z<=365) || (z<=79 && z >=1)
                %Winter
                k=1;
            elseif (z>=135 && z<=257)
                %Sommer
                k=2;
            else
                %bergangszeit
                k=3;
            end
        end
        for s=1:smax
            temp_gruppen(z,s) = group;
            %jeweils passende bergangsmatrix auswhlen (zeitlich
            %unterschiedlich, siehe Zeile 30-35)
            yu = size(unterteilung,2);
            for i=1:yu
                if s<=unterteilung(2,1) || s>unterteilung(2,yu) %Tageswechsel abfangen (nach Ende weiter am Anfang)
                    temp_uebMatr = uebergangsmatr{k,yu};
                    break;
                end
                if s>unterteilung(2,i) && s<=unterteilung(2,i+1) %ACHTUNG: Tageswechsel muss oben abgefangen werden, sonst Fehler
                    temp_uebMatr = uebergangsmatr{k,i};
                    break;
                end
            end
            %falls leere Zeile (in bergangsmatrix) erwischt: benachbarte
            %Gruppe mit nich leerer Zeile verwenden
            ctr = 0;
            while temp_uebMatr(group,end)==0
                ctr = ctr+1;
                %gltige benachbarte Gruppe verwenden
                if group+ctr<=nGruppen && temp_uebMatr(group+ctr,end)~=0
                    group = group+ctr;
                elseif group-ctr>0 && temp_uebMatr(group-ctr,end)~=0
                    group = group-ctr;
                end
            end
            %Gruppenzuordnung fr nchsten Zeitpunkt bestimmen
            group = find(temp_uebMatr(group,:)>zufallsmat(z,s),1,'first');
        end
    end
    %ermittelten Gruppenverlauf bernehmen
    gruppeneinteilungen(:,:,n) = temp_gruppen;
end

disp('Gruppen erstellt')
%Folgender Abschnitt: Leistungswerte anhand der Gruppen zuordnen

%Array mit Lastverlufen aller synthetischen Verbraucher des gesamten
%Jahres vorbereiten
lastverlaeufe_arr = nan(length(days),length(times),nVerbraucher);
%Daten passend anordnen
gruppeneinteilungen_reshaped = cell(365,96);
for z=1:length(days)
    for s=1:smax
        gruppeneinteilungen_reshaped{z,s} = reshape(gruppeneinteilungen(z,s,:),nVerbraucher,1);
    end
end
%Zuordnung vornehmen
leistungen = cell(length(days),smax);
parfor z=1:length(days)
    for s=1:smax
        leistungen{z,s} = zuordnen(gruppeneinteilungen_reshaped{z,s}, verteilungen{z,s}, nVerbraucher)
    end
end
%alle einzelnen Zeipunkte in einem Array speichern
for z=1:length(days)
    for s=1:length(times)
        lastverlaeufe_arr(z,s,:) = reshape(leistungen{z,s},1,1,nVerbraucher);
    end
end      
%als Cell-Array nach Verbrauchern getrennt speichern
lastverlaeufe = cell(nVerbraucher,1);
for n=1:nVerbraucher
    lastverlaeufe{n,1} = lastverlaeufe_arr(:,:,n);
end


%Jahresverbruche normieren (Wunsch: alle Verbraucher haben gleichen
%Jahresverbrauch. Durch unpassende Gruppeneinteilungen gibt es teilweise zu
%groe Abweichungen der Gesamtverbruche einzelner synthetischer
%Verbraucher. Dies wird hier korrigiert.)
disp('Korrigieren')
%Gesamtverbruche der synthetischen Verbraucher ermitteln
istVerbraeuche = nan(nVerbraucher,1);
for n=1:nVerbraucher
   istVerbraeuche(n,1) = sum(nansum(lastverlaeufe{n,1}));
end

%Zielwert ermitteln: Mittelwert aller Verbraucher 
%(~ Gesamtverbrauch des vorgegebenen mittleren Leistungsverlaufs)
targetConsumption = mean(istVerbraeuche);
gruppeneinteilungen_neu = gruppeneinteilungen;
lastverlaeufe_neu = lastverlaeufe;
%Faktor fr Korrektur (reiner Erfahrungswert; mit k=80 als Startwert meist
%gute Ergebnisse)
k=80;
for a=1:20
    fixes = nan(nVerbraucher,1);
    for n=1:nVerbraucher
        istVerbraeuche(n,1) = sum(nansum(lastverlaeufe_neu{n,1}));
        %pro vollstndige "k" kWh + oder - eine Gruppe zu allen Zeitpunkten des Jahres 
        fixes(n,1) = fix((targetConsumption-istVerbraeuche(n,1))/k/4000);
        gruppeneinteilungen_neu(:,:,n) = gruppeneinteilungen_neu(:,:,n) + ...
            fix((targetConsumption-istVerbraeuche(n,1))/k/4000);%1/4000, da Umrechnung von W*1/4h nach kWh
    end
    %Wenn keine groen nderungen mehr: kleinere Schritte
    if max(abs(fixes))<=1 && sum(abs(fixes))<=5
        switch k
            case 80 %wenn noch k=80: grere nderung der Schrittweite
                k = k-10;
            otherwise %sonst kleinere nderung der Schrittweite
                k = k-5;
        end
        disp(['k=' num2str(k)]);
    %Wenn Korrektur beginnt aufzuschwingen (=keine Verbesserung mehr): Abbruch
    elseif max(abs(fixes))>1 && k<80
        break;
    end
    
    gruppeneinteilungen_neu_reshaped = cell(365,96);
    for z=1:length(days)
        for s=1:smax
            gruppeneinteilungen_neu_reshaped{z,s} = reshape(gruppeneinteilungen_neu(z,s,:),nVerbraucher,1);
        end
    end

    leistungen = cell(length(days),length(times));
    parfor z=1:length(days)
        for s=1:smax
        leistungen{z,s} = zuordnen(gruppeneinteilungen_neu_reshaped{z,s}, verteilungen{z,s}, nVerbraucher);
        end
    end

    %alle Zeitpunkte in einem gemeinsamen Array speichern
    lastverlaeufe_arr = nan(length(days),length(times),nVerbraucher);
    for z=1:length(days)
        for s=1:length(times)
            lastverlaeufe_arr(z,s,:) = reshape(leistungen{z,s},1,1,nVerbraucher);
        end
    end
    %als Cell-Array nach Verbrauchern getrennt speichern
    for n=1:nVerbraucher
        lastverlaeufe_neu{n,1} = lastverlaeufe_arr(:,:,n);
    end
    disp([num2str(a) '. Iteration'])
end
end

function [leistungen] = zuordnen(gruppeneinteilung, verteilung, nVerbraucher)
    %Gruppen und Verbraucher fr Zeitpunkt heraussuchen
    temp_zuordnung = [gruppeneinteilung,(1:nVerbraucher)'];
    %Zeilen durchmischen, damit bei gleichen Gruppen nicht immer die
    %kleineren Verbrauchernummern oben stehen
    temp_perm = randperm(nVerbraucher);
    temp_zuordnung = temp_zuordnung(temp_perm,:);
    %nach Gruppen aufsteigend sortieren
    temp_zuordnung = sortrows(temp_zuordnung,1);
    %zuvor erstellte Leistungen laden und aufsteigend sortieren
    temp_leistungen = sortrows(verteilung);
    leistungen(temp_zuordnung(:,2)) = temp_leistungen(:);
end
