function [ lastverlauf ] = h0verlaufErstellen( tagtyp, parameter )
%erstellt den Jahreslastverlauf anhand von Tagesliste und Parametern des
%Standardlastprofils

lastverlauf = nan(length(tagtyp),96);

for tag=1:length(tagtyp)
    if length(tagtyp)==365 %normales Jahr
        %Jahreszeit bestimmen
        %Winter
        if ((tag>=1 && tag<=79) || (tag>=305 && tag<=length(tagtyp)))
            jahreszeit = 0;
        %bergang
        elseif ((tag>=80 && tag<=134) || (tag>=258 && tag<=304))
            jahreszeit = 1;
        %Sommer
        elseif (tag>=135 && tag<=257)
            jahreszeit = 2;
        end
    elseif length(tagtyp) == 366 %Schaltjahr
        %Jahreszeit bestimmen
        %Winter
        if ((tag>=1 && tag<=80) || (tag>=306 && tag<=366))
            jahreszeit = 0;
        %bergang
        elseif ((tag>=81 && tag<=135) || (tag>=259 && tag<=305))
            jahreszeit = 1;
        %Sommer
        elseif (tag>=136 && tag<=258)
            jahreszeit = 2;
        end
    else %Fehler
        error('Tagestypenliste hat ungltige Lnge.')
    end
    
    %Tagesfaktor aus Dynamisierungspolynom bestimmen
    faktor = parameter(865) + tag*parameter(866) + ...
        tag^2 * parameter(867) + tag^3 * parameter(868) + ...
        tag^4 * parameter(869);
    
    %Tagesverlauf anhand von Jahreszeit und Tagestyp heraussuchen
    startval = jahreszeit*96*3 + (tagtyp(tag)-1)*96 + 1;
    endval = startval + 95;
    tagesverlauf = parameter(startval:endval);
    
    %Faktor hinzufgen und eintragen in fertigen Verlauf
    lastverlauf(tag,:) = faktor * tagesverlauf';

end

