function [] = eingabenVerarbeiten(boolReferenzverbraucher,boolPlotten,boolGruppeneinteilungen, ...
    boolVerblAbw,boolPsort,boolStatAnteile,jahr,nConsumer,maxAbw,warnwert, ...
    num_profiltyp,num_ordner)
%wird von Lastprofilgenerator aufgerufen, verarbeitet die GUI-Eingaben
%weiter und startet "Schritte_aufrufen"

%%%%%%%%%%%%%%%%%%%

%prfen, ob gltiges Jahr
if ~(round(jahr)==jahr && jahr<=2020 && jahr>=2006)
    %ungltig->"Schritte_aufrufen" wird nicht gestartet, Eingabe in GUI
    %muss erst korrigiert werden
    disp('Ungltige Jahreszahl eingegeben')
    return
end

%prfen, ob gltige Verbraucherzahl
if ~(nConsumer==round(nConsumer))
    %ungltig->"Schritte_aufrufen" wird nicht gestartet, Eingabe in GUI
    %muss erst korrigiert werden
    disp('Ungltige Verbraucheranzahl eingegeben')
    return
end


%Tagesliste des Jahres laden
dmy = load('Funktionen_Daten\tagtypen2006_2020.mat');
tagtyp = dmy.tagtypen.(['x' num2str(jahr)]);

%Jahreslastverlauf nach Profil erstellen
switch num_profiltyp
    case 1 %angepasstes Profil
        dmy = load('Funktionen_Daten\h0_angepasst.mat');
        Pmean = Funktionen_Daten.h0verlaufErstellen(tagtyp,dmy.h0_angepasst);
    case 2 %Standardprofil
        dmy = load('Funktionen_Daten\h0_standard.mat');
        Pmean = Funktionen_Daten.h0verlaufErstellen(tagtyp,dmy.h0_standard);
    case 3 %eigener Verlauf
        [dmy_name,dmy_pfad]=uigetfile('*.mat','Datei mit Jahreslastverlauf auswhlen'); 
        dmy = load(fullfile(dmy_pfad,dmy_name));
        %dmy = load(uigetfile('.mat','Datei mit Jahreslastverlauf auswhlen'));
        field_dmy = fieldnames(dmy);
        Pmean = dmy.(field_dmy{1});
end

%Zielordner festlegen
switch num_ordner
    case 1 %aktuelles Verzeichnis bestimmen
        dmy = which('Lastprofilgenerator');
        [saveFolder,~,~] = fileparts(dmy);
    case 2
        saveFolder = uigetdir(pwd,'Ausgabeordner auswhlen');
end

%Feststellen, ob Jahr Schaltjahr ist
isSchaltjahr = Funktionen_Daten.schaltjahr_feststellen(jahr);

%Maximale Abweichungen und zugeh. Warnwert anpassen (Eingabe als %-Wert)
maxAbw = maxAbw/100;
warnwert = warnwert/100;

%"eigentliche" Lastprofilgenerierung starten
Funktionen_Daten.Schritte_aufrufen(tagtyp,Pmean,maxAbw,warnwert,isSchaltjahr,boolPsort,...
    boolStatAnteile,boolPlotten,nConsumer,saveFolder,boolReferenzverbraucher,...
    boolGruppeneinteilungen,boolVerblAbw);

end

