function [] = Schritte_aufrufen(tagtyp,Pmean,maxAbw,maxAbwWarn,isSchaltjahr,activatePsort,activateRandom,histPlotten,nConsumer,saveFolder,saveReferenzverbraucher,saveGruppen,saveAbw)
%Hier werden die Schritte zur Erzeugung synthetischer Lastprofile
%aufgerufen

tic

%Zeitraum
%Tage
if isSchaltjahr
    x=1:366;
else
    x = 1:365;  %1 entspricht dem 01.01., 365 dem 31.12. (wenn kein Schaltjahr)
end
%Zeiten
y = 1:96;   %Wird als 1/4-Stunden-Werte pro Tag interpretiert,
            %andere Abstnde nicht mglich!
            %y=1 entspricht dem Zeitraum zwischen 0:00 und 0:15,
            %y=96 entspricht dem Zeitraum zwischen 23:45 und 0:00


%auf Eingabefehler berprfen
    %berprfen, ob Zeitraum zu Leistungsverlauf passt
    if ~isequal(size(Pmean),[length(x),length(y)])
        error('Zeitraum passt nicht zu Leistungsverlauf')
    end
    
    %Tagesliste auf gltige Eintrge prfen
    for n=1:length(tagtyp)
       switch tagtyp(n)
           case 1 %Werktag: ok
           case 2 %Samstag: ok
           case 3 %Sonntag: ok
           otherwise %ungueltiger Eintrag
               error('Ungueltiger Eintrag in Tagesliste')
       end
    end
    
    %Lnge der Tagesliste prfen
    if length(tagtyp)~=length(x)
        error('Falsche Anzahl von Tagen in Tagesliste')
    end
    
%/Eingaben berprfen
    
%statistische Daten laden
try 
    data = load('Funktionen_Daten\statistischeDaten_neu.mat');
catch dmy
    error('Konnte statistische Daten nicht laden: "statistischeDaten_neu.mat" muss geladen werden knnen!')
end
%Daten auf Vollstndigkeit prfen
neededFields = {'k_samstage_wertetabelle','k_sonntage_wertetabelle','k_werktage_wertetabelle', ...
    'sigma_samstage_wertetabelle','sigma_sonntage_wertetabelle','sigma_werktage_wertetabelle', ...
    'mu_const_samstage','mu_const_sonntage','mu_const_werktage', ...
    'mu_var_samstage','mu_var_sonntage','mu_var_werktage','maxPs','minPs'};
for n=1:length(neededFields)
    if ~isfield(data, neededFields{n})
        error([neededFields{n} 'fehlt in Daten'])
    end
end
%zustzliche Daten prfen, wenn auch berlagerte Verteilungen bercksichtigt
%werden sollen
if activateRandom
    neededFields = {'k_verteilung_abw','sigma_verteilung_abw_rel', ...
        'mu_verteilung_abw_rel2','parameter_rand_uebergaenge_kompr_pos', ...
        'parameter_rand_uebergaenge_kompr_kum'}; 
    for n=1:length(neededFields)
        if ~isfield(data, neededFields{n})
            error([neededFields{n} 'fehlt in Daten'])
        end
    end
end
%zustzliche Daten prfen, wenn Leistungen zu sinnvollen Lastverlufen
%sortiert werden sollen (Modellierung von einzelnen Verbrauchern)
if activatePsort
    neededFields = {'lastwechsel'};
    for n=1:length(neededFields)
        if ~isfield(data, neededFields{n})
            error([neededFields{n} 'fehlt in Daten'])
        end
    end
end

%Tests beendet
disp('Keine offensichtlichen Fehler in Eingaben ...')

%"festen" Anteil der Parameter der Verteilungen bestimmen
disp('Parameter bestimmen')
[k_base, sigma_base, mu_base] = Funktionen_Daten.parameterBestimmen_base(x,y,data,tagtyp,Pmean);
%Wenn zufllige berlagerte Verteilungen aktiviert sind, diese hinzufgen
%(k absolut, sigma und mu relativ)
if activateRandom
    disp('Statistische berlagerungen bestimmen')
    [k_rand, sigma_rand, mu_rand] = Funktionen_Daten.parameterBestimmen_rand(x,y,data);
    k = k_base + k_rand;
    sigma = sigma_base .* (sigma_rand+1);
    mu = mu_base + (mu_rand .* mu_base.^2);
else
    k = k_base;
    sigma = sigma_base;
    mu = mu_base;
end

for a=1:nConsumer
    %Leistungsverteilungen erzeugen
    disp('Verteilungen erzeugen')
    [verteilungen, ~, verblAbw] = Funktionen_Daten.pVerteilungErzeugen_neu(k, sigma, mu, k_base, sigma_base, mu_base,Pmean, data.maxPs, data.minPs, maxAbw, maxAbwWarn);


    %Leistungen sinnvoll zu Verbrauchern sortieren
    if activatePsort
        disp('Lastverlufe erstellen');
        [~, lastverlaeufe_neu, referenzverbraucher, ~, gruppeneinteilungen_neu] = Funktionen_Daten.lastVerlaeufeErstellen(x, y, verteilungen, data.lastwechsel, isSchaltjahr);
    end

    if histPlotten
        verbrauch_n = nan(1000,1);
        for n=1:1000
            verbrauch_n(n) = sum(nansum(lastverlaeufe_neu{n,1}))/4000;
        end
        %Histogramm der Jahresverbruche der fertigen Lastverlufe plotten
        figure;hist(verbrauch_n,100)
    end
        
%Speichern    
    lastprofile = struct;
    lastprofile.lastverlaeufe = lastverlaeufe_neu;
    if saveReferenzverbraucher
        lastprofile.referenzverbraucher = referenzverbraucher;
    end
    if saveGruppen
        lastprofile.gruppeneinteilungen = gruppeneinteilungen_neu;
    end
    if saveAbw
        lastprofile.verbleibendeAbweichungen = verblAbw;
    end
    
    fileName = 'lastprofile';
       
    tmp = strrep(datestr(clock), ':' , '-' );%
    s= strrep(tmp, ' ' , '-' );%
    ii=find(s=='-');%
    s(ii(4))='h';%
    s(ii(5))='m';%
    s=strcat(s, 's');%->Erzeugung eines Datestrings, der keine beim Speichern ungltigen Zeichen enthlt.
    
    if nConsumer==1
        fileName = [fileName '_' s '.mat'];
    else
        fileName = [fileName '_' s '_' num2str(a) 'v' num2str(nConsumer) '.mat'];
    end
    save(fullfile(saveFolder,fileName), 'lastprofile')
end
disp('Fertig')
toc




end

