# 2020 payments to patient organisations (POs) from pharmaceutical companies 
---

## Description of the data collection process

We retrieved data on 2020 payments from pharmaceutical companies to patient organisations from the following sources:
1)	Companies’ websites. Disclosing payments to patient organisations is a requirement of Clause 29 of the Association of British Pharmaceutical Industry (ABPI) Code of Practice. Specifically, the ABPI requires companies to keep a public record of any payment made to patient organisations on their website for a minimum of three years following the payment.1 Therefore, companies’ website were our primary data source on payments to patient organisations. 
2)	Disclosure UK HCOs database. In light of a recent study unveiling that payments to patient organisations were misreported in the Disclosure UK database of payments to healthcare organisations (HCOs), we also screened the 2020 Disclosure UK HCOs database for payments to patient organisations.

If payments were not disclosed in the company’s website nor in the Disclosure UK HCOs database, we assumed that the company did not make any payments to patient organisations in 2020, as commonly assumed in the literature.
One investigator (AG) extracted payment disclosures from the companies’ websites. These comprised the name of the patient organisation, the year when the payment was made, the reason for the payment and its value in the currency reported by the disclosing company. The 2020 Disclosure UK HCOs database was also screened, and recipients were matched to standardised patient organisations names. To ensure the data's accuracy, the final database was scanned for duplicates, but no such instances were found. When reported in different currencies, such as United States Dollars (USD), Swiss Franc (CHF), Swedish Krona (SEK), Norwegian Krone (NKK) and Danish Krone (DKK), the value of the payment was converted to Great British Pounds (GBP), using the ONS historical yearly conversion rates. Two in-kind payments with a monetary value of zero were excluded from the analysis. Further details on variables’ cleaning and coding can be found in the Supplemental Material.  

For further details, please see the full publication on BMJ Open "Industry funding of patient organisations in the United Kingdom: A retrospective study of commercial determinants, funding concentration and disease prevalence".

## Sharing/Access information

Data was derived from the following sources:
  * https://search.disclosureuk.org.uk/
  * https://search.disclosureuk.org.uk/


Details for: Industry payments to POs_2020 v.2.xlsx
---------------------------------------

* Description: Excel spreadsheet containing informations related to payments from pharmaceutical companies to UK patient organisations in 2020
* Format(s): .xlsx
* Size(s): 3.47MB
* Number of sheets: 5 

**Please note that empty cells throughout the Excel file indicate missing information and are intentionally left empty to avoid interfering with the existing formulas and the STATA dofile.**

1)  Sheet: Payments_2020
*This sheet presents an overview of the payments made from pharmaceutical companies to patient organisations (POs), including details on the companies, the receiving organisaitons and the amount paid*

Variables:
* Company: Standardised company name 
* Company_condition: Concatenation of company name and disease area targeted by the PO
* Company interest: Whether the company hold an interest in the condition targeted by the PO
* Source: Source of company interest variable
* Comments: Any comment worth noting
* Name of PO: Name of PO as reported by companies in disclosure report
* Standardised PO name: Standardised name of PO to avoid duplicates and inconsistencies 
* Include/exclude: Whether the PO is inclduded or excluded from the analysis 
* Reason for exclusion: Reason why the organisation was excluded from the analysis 
* Type of organisation: Type of PO (e.g., multipurpose organisation, support organisation etc.)	
* ICD-11: Classification of disease targeted by the PO according to the WHO ICD-11
* Condition: Condition targeted by PO as reported on website
* Charity number (if any): Charity number as reported in the organization website or as reported in the England and Wales Charity Commission website
* Company number (if charity number missing): Company number as reported in the organization website or as reported in the Government Company Information Service wesbite if the PO cannot be found in the charity commission database (e.g. limited by guarantee company)
* UK/International: Whether the PO is operating in the UK only or if has international reach	
* Link: Link of PO website
* Rare disease: Whether the condition or one of the conditions targeted by the PO is considered as rare 
* Single/Alliance Pos: Whether the PO is a single organisation or an alliance of multiple organisations	
* Details of payment: Details of payment as reported by companies in disclosure report
* Country: Country of payment
* Year: Year of payment
* Currency: Currency of payment
* Currency_year: Concatenation of currency and year of payment for conversion purposes
* Value of payment: Value of payment in original currency as reported by companies in disclosure report
* Value in 2020 pounds: GBP converted value of payment
* Companies' website POs: Indicates whether the payment was found on the companies' website	 
* Disclosure UK HCOs: Indicates whether the payment was found on the Disclosure UK HCOs database



2) Sheet: Inputs

This sheet containts information regarding:
* Inflation adjustments and conversion rates, retrieved from the UK Office for National Statistics
* Hardcoded inputs for drop-down menus used throughout the Excel file (i.e., WHO ICD-11, reasons for PO exclusion, types of POs, rarity of diseases)


3. Sheet: Pat_org

*This sheet contains information of the POs receiving payments, such as wehther they target a rare disease or not, the nature of their activities and the linked charity number if available*

Variables
* Standardised name: Standardised name of PO to avoid duplicates and inconsistencies 
* Standardised name - Hardcoded: Standardised name of PO to avoid duplicates and inconsistencies (hardcoded)
* Include/exclude: Whether the PO is inclduded or excluded from the analysis 
* Reason for exclusion: Reason why the organisation was excluded from the analysis 
* Type of organisation: Type of PO (e.g., multipurpose organisation, support organisation etc.)	
* ICD-11: Classification of disease targeted by the PO according to the WHO ICD-11
* Condition: Condition targeted by PO as reported on website	
* Charity number (if any): Charity number as reported in the organization website or as reported in the England and Wales Charity Commission website
* Company number (if charity number missing): Company number as reported in the organization website or as reported in the Government Company Information Service wesbite if the PO cannot be found in the charity commission database (e.g. limited by guarantee company)	
* UK/International: Whether the PO is operating in the UK only or if has international reach	
* Link: Link of PO website
* Rare disease: Whether the condition or one of the conditions targeted by the PO is considered as rare
* Single/Alliance Pos: Whether the PO is a single organisation or an alliance of multiple organisations	
* Comment: Any comment worth noting
* Overall payments: Overall payments from pharmaceutical companies to PO in 2020	


4. Sheet: Comp_interest

*This sheet containts information on whether the company making the payment(s) has an interest in the condition targeted by the PO. Please note that an interest is when there is, or could be perceived to be, an opportunity for a pharmaceutical company to benefit in the disease area where the patient organisation operates.*

Variables

* Unique concatenation company_condition (live): Live unique concatenation of company name and condition targeted by the PO supported financially
* Unique concatenation company_condition (pasted): Unique concatenation of company name and condition targeted by the PO supported financially pasted
* Company interest: Whether the company has an interest in the condition targeted by the PO
* Source: Source indicating interest
* Comments: Any comment worth noting  

5. Sheet: ICD11

*This sheet contains information on the coding hierarchy for ICD-11 codes used in the analysis*

* Condition - Hardcoded: Harcoded unique list of conditions targeted by POs receiving payments from pharmaceutical company
* ICD-11 code: Corresponding ICD-11 code
* ICD-11 level 1: Level 1 of ICD-11 code
* ICD-11 level 2: Level 1 of ICD-11 code	
* ICD-11 level 3: Level 1 of ICD-11 code	
* ICD-11 level 4: Level 1 of ICD-11 code	
* Rare disease: Indicates whether the disease targeted by the PO is rare or not
* Source: Source indicating rarity of disease	
* Comments: Any comment worth noting
* Prevalence (per 100,000): Prevalence of rare disease (per 100,000) if available. Asterisks refer to EU-specific prevalence data. 


## Code/Software

N/A