from _string_assembly import string_assembly

def calc_string_assembly(input_string):
    """ Call the C++ function `string_assembly` and parse the output string into a dictionary"""
    # Run the C++ function
    output_strings = string_assembly([input_string])
    # Parse the data into a list of dictionaries - one for each pathway
    output_data = parse_output_string(output_strings)

    return output_data

def parse_output_string(output_strings):
    """ Parse output string from C++ function into a list of dictionaries """
    # Record a list of dictionaries
    output_data = []
    # Indicate whether a pathway was found or not
    no_pathway = False
    # Each pathway is its own string
    for pathway in output_strings:
        # Record the details in a dictionary
        this_pathway = dict()
        # Split the data at the dashes and drop whitespace
        pathway_data = pathway.split("-")
        pathway_data = [p.strip() for p in pathway_data if p.strip() != ""]
        # The first element of the split will contain the ID number of the
        # pathway - unless there isn't one.
        pathway_number = pathway_data[0]

        if "No pathway" in pathway_number:
            # If there is no pathway we just want to record the index
            no_pathway = True
        elif "Pathway" not in pathway_number:
            # TODO: update to proper error handling
            print("Parsing Error, Pathway not found in number string")
            exit()
       

        if not no_pathway:
            # If there is a pathway we record the ID number
            pathway_number = pathway_number.split(" ")[-1]
            pathway_number_int = int(pathway_number.strip())

            this_pathway["number"] = pathway_number_int
        else:
            # Otherwise set it to zero
            this_pathway["number"] = 0

        # Get the index not matter what
        pathway_index = pathway_data[1]
        if "Assembly Index" not in pathway_index:
            # TODO: Update to proper error handling
            print("Parsing Error, Assembly Index not in index string")
            exit()
        
        # Get the index 
        pathway_index = pathway_index.split("=")[1]
        pathway_index = int(pathway_index.strip())
        this_pathway["index"] = pathway_index

        # IF a pathway was discovered 
        if not no_pathway:
            # Get the key steps and uses 
            key_steps = []
            # Iterate over the key steps
            for step in pathway_data[2:]:
                this_step = [s.strip() for s in step.split("*")]
                count = int(this_step[0])
                piece = this_step[1]
                key_steps.append( (count, piece) )

            this_pathway["key_steps"] = key_steps

        output_data.append(this_pathway)

    return output_data