#pragma once
#include "overallDefine.h"
#include "RNA.h"
#include <chrono>


/* =========================================== */
class FILTERED_UNIT {
public:
	std::string dup{};
	sizeVec sche{};
	size_t dupID0 = 0, dupID1 = 0;

	FILTERED_UNIT() {};
};


/* =========================================== */
class SCHEME {
public:
	std::string seqComb{};
	sizeVec idGroup0{}, idGroup1{};

	sizeVec scheID{}, sche{}, cutMix{};
	size_t cutMixEnd = 0;
	std::string newSeq{}, newSeq2{};

	std::vector<sizeVec> scheSAVE{};
	sizeVec dupID0SAVE{}, dupID1SAVE{};


	//---------------------------
	SCHEME() {};
	SCHEME(RNA&);

	int initSche();
	int nextSche_skip();
	int nextSche_further();
	bool findDup(int);


private:
	int cutSeq(size_t);
	void restore(size_t);
	size_t nextValid(size_t);
	bool findDup_partial(std::string&, size_t, size_t);
	void saveScheUniq(size_t, size_t);
};


/* =========================================== */
std::vector<FILTERED_UNIT> filter(RNA&, 
	std::chrono::time_point<std::chrono::steady_clock>& startTime,
	sizeVec& idSKMax, std::vector<int>& idNow_id);