#include "filter.h"
#include <algorithm>
#include <iostream>
#include <chrono>


/* =========================================== */
// It displays the current iterating level (and cutting scheme) 
// in console when the program is running.
void displayScheme(SCHEME& sc, sizeVec& idSKMax, std::vector<int>& idNow_id) {

	if (idNow_id.empty()) {
		std::cout << " ";
	}
	else {
		for (int i = 0; i < idNow_id.size() - 1; ++i)
			std::cout << idNow_id[i] << ",";
		std::cout << idNow_id.back();
	}

	std::cout << " (";
	if (idSKMax.empty()) {
		std::cout << "0th level";
	}
	else {
		for (int i = 0; i < idSKMax.size() - 1; ++i)
			std::cout << idSKMax[i] << ",";
		std::cout << idSKMax.back();
	}
	std::cout << "): ";

	std::cout << sc.cutMix.size() << " possible cuts --> ";
	for (size_t& i : sc.scheID)
		std::cout << i << "  ";
	std::cout << "continued..." << std::endl;
}


/* =========================================== */
std::vector<FILTERED_UNIT> filter(RNA& rna0,
	std::chrono::time_point<std::chrono::steady_clock>& startTime,
	sizeVec& idSKMax, std::vector<int>& idNow_id) {

	std::vector<FILTERED_UNIT> filtered{};

	// check if there are already duplications
	std::string temp;
	size_t i0, i1, j0, j1;
	for (size_t iID = 0; iID < rna0.seqIdx0.size(); ++iID) {
		i0 = rna0.idGroup0[rna0.seqIdx0[iID]];
		i1 = rna0.idGroup1[rna0.seqIdx0[iID]];
		temp = rna0.seqComb.substr(i0, i1 - i0 + 1);
		for (size_t jID = iID + 1; jID < rna0.seqIdx0.size(); ++jID) {
			j0 = rna0.idGroup0[rna0.seqIdx0[jID]];
			j1 = rna0.idGroup1[rna0.seqIdx0[jID]];
			if (i1 - i0 == j1 - j0) {
				if (temp.compare(rna0.seqComb.substr(j0, j1 - j0 + 1)) == 0) {
					filtered.resize(1);
					filtered[0].dupID0 = i0;
					filtered[0].dupID1 = i1;
					filtered[0].dup = temp;
					return filtered;
				}
			}
		}
	}


	// check if no valid cut can be made
	SCHEME sc(rna0);
	if (sc.cutMix.empty())
		return filtered;


	std::chrono::time_point<std::chrono::steady_clock>
		lastTimeDisplay = startTime, currentTime;
	std::chrono::duration<double> timeSinceLastChrono;
	const size_t displayLength = 0;
	//---------------------------
	int cutCase = sc.initSche();
	bool dupFound;
	do {
		dupFound = sc.findDup(cutCase);
		if (dupFound) {

			cutCase = sc.nextSche_skip();
		}
		else {
			cutCase = sc.nextSche_further();
		}
	} while (cutCase != 0);



	// clean up repeated-in-fact schemes
	std::vector<std::string> dupSAVE(sc.scheSAVE.size()), resSAVE(sc.scheSAVE.size());
	std::string resThis{};
	std::vector<std::string> resThisVec{};
	size_t j;
	sizeVec idGroup0This, idGroup1This;
	for (size_t i = 0; i < sc.scheSAVE.size(); ++i) {
		// cut sequence first based on scheSAVE[i]
		idGroup0This = sc.idGroup0;
		idGroup1This = sc.idGroup1;
		for (size_t k = 0; k < sc.scheSAVE[i].size(); ++k) {
			j = sc.scheSAVE[i][k];
			if (j == idGroup0This[j]) { // FIRST letter is cut
				for (auto it = idGroup0This.begin() + j + 1; it <= idGroup0This.begin() + idGroup1This[j]; ++it)
					*it = j + 1;
				idGroup1This[j] = j;
			}
			else {
				if (j == idGroup1This[j] - 1) { // LAST letter is cut
					idGroup0This[j + 1] = j + 1;
					for (auto it = idGroup1This.begin() + idGroup0This[j]; it <= idGroup1This.begin() + j; ++it)
						*it = j;
				}
				else { // cut between FIRST and LAST
					for (auto it = idGroup0This.begin() + j + 1; it <= idGroup0This.begin() + idGroup1This[j]; ++it)
						*it = j + 1;
					for (auto it = idGroup1This.begin() + idGroup0This[j]; it <= idGroup1This.begin() + j; ++it)
						*it = j;
				}
			}
		}

		// generate dupSAVE & resSAVE for comparison later
		i0 = sc.dupID0SAVE[i];
		i1 = sc.dupID1SAVE[i];
		dupSAVE[i] = sc.seqComb.substr(i0, i1 - i0 + 1);

		resThisVec = {};
		j = 0;
		while (j < i0) {
			resThisVec.emplace_back(sc.seqComb.substr(idGroup0This[j], idGroup1This[j] - idGroup0This[j] + 1));
			j = idGroup1This[j] + 1;
		}
		j = i1 + 1;
		while (j < idGroup0This.size()) {
			resThisVec.emplace_back(sc.seqComb.substr(idGroup0This[j], idGroup1This[j] - idGroup0This[j] + 1));
			j = idGroup1This[j] + 1;
		}
		std::sort(resThisVec.begin(), resThisVec.end());
		resThis = "";
		for (size_t k = 0; k < resThisVec.size(); ++k) {
			resThis.append(resThisVec[k]);
			resThis.push_back(',');
		}
		resSAVE[i] = resThis;
	}

	// filter out repeated schemes
	bool repeatFound;
	sizeVec id{};
	for (size_t i = 0; i < sc.scheSAVE.size(); ++i) {
		repeatFound = false;
		for (size_t j = i + 1; j < sc.scheSAVE.size(); ++j) {
			if (sc.scheSAVE[i].size() == sc.scheSAVE[j].size()
				&& dupSAVE[i].size() == dupSAVE[j].size()
				&& dupSAVE[i].compare(dupSAVE[j]) == 0
				&& resSAVE[i].compare(resSAVE[j]) == 0) {

				repeatFound = true;
				break;
			}
		}
		if (!repeatFound)
			id.emplace_back(i);
	}
	// clean up repeated-in-fact schemes
	//---------------------------


	j = id.size();
	filtered.resize(j);
	for (size_t i = 0; i < j; ++i) {
		filtered[i].sche = sc.scheSAVE[id[i]];
		filtered[i].dupID0 = sc.dupID0SAVE[id[i]];
		filtered[i].dupID1 = sc.dupID1SAVE[id[i]];
		filtered[i].dup = rna0.seqComb.substr(filtered[i].dupID0, filtered[i].dupID1 - filtered[i].dupID0 + 1);
	}

	return filtered;
}
