#include "depthFirst.h"
#include <iostream>


/* =========================================== */
CASHING::CASHING(size_t CashingSize0, size_t CashingVacuumSize0, size_t CashingVacuumSeqLen0) {
	std::unordered_map <std::string, CASHING_UNIT> data{};
	bool notExist = true, saturated = false, onceFulled = false;
	CashingSize = CashingSize0;
	CashingVacuumSize = CashingVacuumSize0;
	CashingVacuumSeqLen = CashingVacuumSeqLen0;
}


/* =========================================== */
std::vector<FILTERED_UNIT> CASHING::find(RNA& rna) {
	auto it = data.find(rna.seqComb);
	if (it == data.end()) {
		notExist = true;
		return std::vector<FILTERED_UNIT>{};
	}
	else {
		bool found = false;
		size_t iFound;
		for (size_t i = 0; i < it->second.seqList.size(); ++i) {
			if (rna.seqIdx0 == it->second.seqList[i]) {
				found = true;
				iFound = i;
				break;
			}
		}
		if (found) {
			notExist = false;
			return it->second.filteredList[iFound];
		}
		else {
			notExist = true;
			return std::vector<FILTERED_UNIT>{};
		}
	}
}


/* =========================================== */
void CASHING::add(RNA& rna, std::vector<FILTERED_UNIT>& filtered) {
	auto thisItem = data.find(rna.seqComb);
	if (thisItem == data.end()) { // if not found, then check if add new key-value pair
		bool addReally = false;
		if (data.size() < CashingSize) { addReally = true; }
		else {
			if (onceFulled) {
				if (saturated) {
					if (rna.seqComb.size() <= CashingVacuumSeqLen) { return; }
					else {
						// delete random cashing items
						size_t n = 0;
						auto it = data.begin();
						while (it != data.end()) {
							it = data.erase(it);
							n++;
							if (n == CashingVacuumSize) break;
						}
						addReally = true;
					}
				}
				else {
					if (rna.seqComb.size() <= CashingVacuumSeqLen) { return; }
					else {
						// delete samll cashing items
						size_t n = 0;
						auto it = data.begin();
						while (it != data.end()) {
							if (it->first.size() > CashingVacuumSeqLen) { it++; }
							else {
								it = data.erase(it);
								n++;
							}
							if (n == CashingVacuumSize) break;
						}
						if (n < CashingVacuumSize) {
							saturated = true;
							if (n == 0) {
								// delete 1st cashing item
								data.erase(data.begin());
							}
						}
						addReally = true;
					}
				}
			}
			else {
				onceFulled = true;
				// delete one small cashing item
				bool DelFail = true;
				auto it = data.begin();
				while (it != data.end()) {
					if (it->first.size() <= CashingVacuumSeqLen) {
						data.erase(it);
						DelFail = false;
						break;
					}
					it++;
				}
				if (DelFail) // delete 1st cashing item
					data.erase(data.begin());
				addReally = true;
			}
		}

		// implement adding
		if (addReally) {
			CASHING_UNIT temp{};
			temp.seqList.emplace_back(rna.seqIdx0);
			temp.filteredList.emplace_back(filtered);
			data[rna.seqComb] = temp;
		}

	}
	else { // if found
		thisItem->second.seqList.emplace_back(rna.seqIdx0);
		thisItem->second.filteredList.emplace_back(filtered);
	}
}