#pragma once
#include "overallDefine.h"
#include "RNA.h"
#include "filter.h"
#include <chrono>
#include <unordered_map>
#include <string>

/* =========================================== */
class IDSTACK {
public:
	std::vector<int> id{};// records the current searching level, e.g. [0, 0, 1]
	size_t size = 0; // = id.size()
	std::string idStr = ""; // transforms id{} into string type, e.g. "0,0,1,"


	// ------ fucntions ------
	IDSTACK() {};


	// It builds the IDSTACK instance based on str0 that records
	// IDSTACK information in the format of string.
	void renew(std::string&);


	// It returns a string type from id[0] to id[i]
	// e.g. if id=[0, 0, 1, 2, 1], 
	// then from_0toi(2) gives "0,0,1"
	std::string from_0toi(int);
};


/* =========================================== */
class ONE_PATH {
public:
	std::vector<std::string> dups{};
	sizeVec dupN{};
	size_t PAIdx = 0;

	ONE_PATH() {};
};


/* =========================================== */
class CASHING_UNIT {
public:
	std::vector<sizeVec> seqList{};
	std::vector<std::vector<FILTERED_UNIT>> filteredList{};
	CASHING_UNIT() {};
};

class CASHING {
public:
	std::unordered_map <std::string, CASHING_UNIT> data{};
	bool notExist = true, saturated = false, onceFulled = false;
	size_t CashingSize = 0, CashingVacuumSize = 0, CashingVacuumSeqLen = 0;

	CASHING() {};
	CASHING(size_t, size_t, size_t);
	std::vector<FILTERED_UNIT> find(RNA&);
	void add(RNA&, std::vector<FILTERED_UNIT>&);
};


/* =========================================== */
std::vector<ONE_PATH> depthFirstSearch(RNA&,
	std::chrono::time_point<std::chrono::steady_clock>&,
	size_t, size_t, size_t);