#include "overallDefine.h"
#include "filter.h"
#include "depthFirst.h"
#include <iostream>
#include <fstream>
#include <chrono>
#include <sstream>
#include <string>

void printInstruction(STRING&);
STRING outputPathVec(RNA, std::vector<ONE_PATH>, int, STRING, STRING, STRING, double);
// random seed in filter_SCHEME.cpp


/* =========================================== */
std::string string_assembly(std::vector<STRING>& rnaTXT) {

	// --------------------- Version --------------------
	STRING versionStr = "2020.04.23,10:00";
	// --------------------- Version --------------------

	size_t CashingSize = 10000000; // >= 10000,  2^24 = 16,777,216
	size_t CashingVacuumSize = 10000; // >= 1
	size_t CashingVacuumSeqLen = 15; // >= 2
	// When the user allows the console shows the running process,
	// it shows at the time when 
	// (total number of possible links - displayLengthCutOff) number of links are cut


	RNA rna0(rnaTXT);


	// Write to output file that it is running.
	std::vector<ONE_PATH> pathVec{};
	outputPathVec(rna0, pathVec, 1, versionStr, 0);

	std::chrono::time_point<std::chrono::steady_clock> startTIME, endTIME;
	startTIME = std::chrono::steady_clock::now();
	// ---------------------------------------------------------------
	// ------ function depthFirstSearch() is the main process ------
	pathVec = depthFirstSearch(rna0, startTIME,
		CashingSize, CashingVacuumSize, CashingVacuumSeqLen);
	// ---------------------------------------------------------------
	// ---------------------------------------------------------------
	endTIME = std::chrono::steady_clock::now();

	std::chrono::duration<double> running_time = endTIME - startTIME;
	double ElapsedTime = running_time.count();
	// Write final output.
	std::string output = outputPathVec(rna0, pathVec, 2, versionStr, ElapsedTime);

	return output;
}



/* =========================================== */
// Print instruction in console
void printInstruction(STRING& versionStr) {
	STRING exeName = "[this-exe-file-name].exe";

	std::cout << std::endl << "==============================" << std::endl;
	std::cout << ".Version: This exe-file (version-caching) was created on "
		<< versionStr << std::endl << std::endl;
	std::cout << "How to run the exe-file in command line:" << std::endl
		<< "1. Enter \'" << exeName << "\'," << std::endl
		<< "     it will analyse the txt-file \'Default.txt\';" << std::endl
		<< "2. Enter \'" << exeName << " [txt-file-name].txt\'," << std::endl
		<< "     it will analyse the txt-file \'[txt-file-name].txt\'," << std::endl
		<< "     and it shows the progress around every 10 seconds;" << std::endl
		<< "3. Enter \'" << exeName << " [txt-file-name].txt --[option]:[option_value]\'," << std::endl
		<< "     it will analyse the txt-file \'[txt-file-name].txt\'" << std::endl
		<< "     with various options, referring to readme file." << std::endl;
	std::cout << "==============================" << std::endl << std::endl;
}



/* =========================================== */
std::string outputPathVec(RNA rna0, std::vector<ONE_PATH> pathVec, int stage,
	STRING versionStr, double ElapsedTime) {

	std::stringstream pathVecFile;
    std::string output = "";
	// 1st stage of output, just write down to files that the program is running.
	if (stage == 1) {

		pathVecFile << "The output was generated by the exe-file created on "
			<< versionStr << std::endl << std::endl;
		pathVecFile << "The sequences to be analysed are:" << std::endl;
		pathVecFile << "--------------------" << std::endl;
		pathVecFile << rna0.seqComb[0];
		for (size_t i = 1; i < rna0.seqComb.size(); ++i) {
			if (rna0.idGroup0[i] != rna0.idGroup0[i - 1]) {
				pathVecFile << std::endl << std::endl;
			}
			pathVecFile << rna0.seqComb[i];
		}
		pathVecFile << std::endl;
		pathVecFile << "--------------------" << std::endl << std::endl;

		pathVecFile << ". Number of sequences: " << rna0.seqIdx0.size() << std::endl;
		pathVecFile << "  (";
		for (size_t i = 0; i < rna0.seqIdx0.size() - 1; ++i) {
			pathVecFile << rna0.seqIdx0[i + 1] - rna0.seqIdx0[i] << ",";
		}
		pathVecFile << rna0.idGroup0.size() - rna0.seqIdx0.back() << ")";

		pathVecFile << std::endl << ". Total number of letters: "
			<< rna0.seqComb.size() << std::endl;

		pathVecFile << std::endl << "Please wait until the task completes..."
			<< std::endl;
		output = pathVecFile.str();
	}


	// 2nd stage of output, write down final output to files.
	if (stage == 2) {
		std::stringstream pathVecFile;
        std::string output = "";
		pathVecFile << "=================================================="
			<< std::endl;
		pathVecFile << "=============== Now task completed ==============="
			<< std::endl;
		pathVecFile << "=================================================="
			<< std::endl;
		pathVecFile << "Elapsed time: " << ElapsedTime << " s" << std::endl;
		pathVecFile << "Number of pathways: " << pathVec.size() << std::endl
			<< std::endl << std::endl;


		if (pathVec.empty()) {
			int PAIdx = rna0.seqComb.size() - rna0.seqIdx0.size();

			pathVecFile << "=================" << std::endl;
			pathVecFile << "=== No pathway found ===" << std::endl;
			pathVecFile << "=================" << std::endl;

			pathVecFile << ". Assembly Index = " << PAIdx << std::endl;
			pathVecFile << std::endl << std::endl;
		}
		else {
			size_t k = 0;
			for (ONE_PATH& path : pathVec) {
				k++;
				pathVecFile << "=================" << std::endl;
				pathVecFile << "=== Pathway " << k << " ===" << std::endl;
				pathVecFile << "=================" << std::endl;

				pathVecFile << ". Assembly Index = " << path.PAIdx << std::endl;
				for (size_t i = 0; i < path.dupN.size(); ++i) {
					pathVecFile << path.dupN[i] << " * " << path.dups[i] << std::endl;
				}
				pathVecFile << std::endl << std::endl;
			}
		}

		output = pathVecFile.str();
	}
    return output;
}