#include "RNA.h"
#include <numeric>
#include <algorithm>


/* =========================================== */
RNA::RNA(std::vector<std::string>& rnaTXT) {
	size_t idxPre;
	sizeVec seqIdx1{};
	std::sort(rnaTXT.begin(), rnaTXT.end());
	for (size_t i = 0; i < rnaTXT.size(); ++i) {
		if (rnaTXT[i].size() > 1) {
			idxPre = seqComb.size();
			seqComb.append(rnaTXT[i]);
			seqIdx0.emplace_back(idxPre);
			seqIdx1.emplace_back(seqComb.size() - 1);
		}
	}

	size_t temp0, temp1;
	idGroup0.resize(seqComb.size());
	std::iota(idGroup0.begin(), idGroup0.end(), 0);
	idGroup1 = idGroup0;
	for (size_t i = 0; i < seqIdx0.size(); ++i) {
		temp0 = seqIdx0[i];
		temp1 = seqIdx1[i];
		for (auto iter = idGroup0.begin() + temp0; iter <= idGroup0.begin() + temp1; ++iter)
			*iter = temp0;
		for (auto iter = idGroup1.begin() + temp0; iter <= idGroup1.begin() + temp1; ++iter)
			*iter = temp1;
	}
}
