from setuptools import setup
from setuptools import find_packages
# Available at setup time due to pyproject.toml
from pybind11.setup_helpers import Pybind11Extension, build_ext



__version__ = "0.0.1"

# The main interface is through Pybind11Extension.
# * You can add cxx_std=11/14/17, and then build_ext can be removed.
# * You can set include_pybind11=false to add the include directory yourself,
#   say from a submodule.

ext_modules = [
    Pybind11Extension("_string_assembly",
                      ["src/main.cpp",
                       "src/RNA.cpp",
                       "src/depthFirst.cpp",
                       "src/depthFirst_CASHING.cpp",
                       "src/depthFirst_IDSTACK.cpp",
                       "src/filter.cpp",
                       "src/filter_SCHEME.cpp"],
                      # Example: passing in the version to the compiled code
                      define_macros=[('VERSION_INFO', __version__)],
                      ),
]

setup(
    name="string_assembly",
    version=__version__,
    author="Cole Mathis and Ernest Yu Liu",
    author_email="cole.mathis.ool@gmail.com",
    url="https://gitlab.com/croningroup/cheminformatics/string-assembly",
    description="A Python and C++ package for computing String Assemblies",
    long_description="",
    packages=find_packages(where = 'src'),
    package_dir={"": "src"},
    ext_modules=ext_modules,
    extras_require={"test": "pytest"},
    # Currently, build_ext only provides an optional "highest supported C++
    # level" feature, but in the future it may provide more features.
    cmdclass={"build_ext": build_ext},
    zip_safe=False,
)
