#ifndef ENSURE_LOOP_FUNCTIONS
#define ENSURE_LOOP_FUNCTIONS

#ifdef HILAPP

#include "field.h"

// This file contains dummy functions, the purpose of which is just to
// excercise hilapp code generation for specific loop functions.  This is
// needed because calls to these functions may be generated by hilapp and it's easier to let
// generic code generation handle this.
//
// These can be called only by hilapp, so insert calls within #ifdef HILAPP .. #endif
// 
// call these as e.g. "ensure_unary_minus_is_loop_function<T>();"


template <typename T>
void ensure_unary_minus_is_loop_function() {
    if constexpr (has_unary_minus<T>::value) {
        Field<T> f;
        onsites(ALL) f[X] = -f[X];
        onsites(ALL) if (X.coordinate(e_x) == 0) f[X] = -f[X];
    }
}

template <typename T>
void ensure_assign_zero_is_loop_function() {
    Field<T> f;
    onsites(ALL) f[X] = 0;
    onsites(ALL) if (X.coordinate(e_x) == 0) f[X] = 0;
}

#endif
#endif