# Please read this meta data for descriptions of all the data used for 
## "Direct observation to assess the effects of habitat structure and complexity on resource-use behaviour of butterflies: a study case in smallholding oil palm plantations in Peninsular Malaysia"
# Authors: "Martina F. Harianja1*, Wan Z. W. Mamat2, Muhamad A. Hadi2, Jake Stone1, Badrul Azhar2,3, Sarah H. Luke4,1, Edgar C. Turner1"
# 1Department of Zoology, University of Cambridge, Downing Street, Cambridge CB2 3EJ, UK
# 2Department of Forestry Science and Biodiversity, Faculty of Forestry and Environment, Universiti Putra Malaysia, 43400 UPM Serdang, Selangor, Malaysia 
# 3School of Biosciences, University of Nottingham, Sutton Bonington Campus, Nr Loughborough, LE12 5RD
# 4Biodiversity Unit, Institute of Bioscience, Universiti Putra Malaysia, 43400 Serdang, Selangor, Malaysia
# *Corresponding author: mfh46@cam.ac.uk, martina.f.harianja@gmail.com (the gmail is the permanent email)



# Funding and research permission
## Jardine Foundation, the Cambridge Trust, and Tim Whitmore Fund provided funding for MFH, 
### the Biotechnology and Biological Sciences Research Council (BBSRC) funded JS (USN: 304338625), and
### BBSRC (BB/T012366/1) provided funding for the establishment of the plots and surveys of environmental parameters.
## Research permission was provided by the Economic Planning Unit (EPU) of the Prime Minister's Department;
### permission was for MFH (Ref: EPU 40/200/19/3727) and JS (Ref: MEA 40/200/19/3705).



# Overall description
## This meta data describes all the data we used in this study. 
## We investigated how habitat structure and complexity within smallholding oil palm plantations affected resource-use behaviours of two common butterfly 
### species in the study areas (oil palm plantations in Banting, Selangor, Malaysia): Leptosia nina (Pieridae) and Ypthima spp. (Nymphalidae).
## Using direct-observation methods we developed, we followed seven and nine individuals of each species respectively, for three minutes in smallholder-owned 
### immature monoculture and polyculture oil palm, and mature monoculture oil palm plantations. 
## We recorded distance travelled by each individual from both straight line and the sums of distances between all perching points, and the position and 
### characteristics of each perch location, where the individual landed. 
## We compared our observations to control runs, generated by pairing observed distances travelled, but selecting the direction for each movement at random. 
## By comparing the distance travelled and characteristics of locations used by butterflies and paired control points across habitats, we assessed how 
### individuals in the two species used the local environment and whether this differed with habitat structure and complexity.



# Data used

## 1. BtflyControls_plots
### Description: this file contains data used to create plots showing comparisons of the behaviours of the observed butterflies and their paired controls.
#### There are 6 columns consisting of details of the observations on individuals of each butterfly species and their paired controls.
### Columns: 
#### 1. ButterflyGroup: indicating the species group of the observed butterfly.
##### Levels: 
###### 1. Leptosia.nina,
###### 2. Ypthima.spp. ("spp." because identification could not be made to species levels because the butterflies were not caught).
#### 2. BtflyOrControl: indicating if the observation was on the butterflies or their paired controls.
##### Levels: 
###### 1. Butterfly,
###### 2. Control.
#### 3. ButterflyReps: showing the replicates of each butterfly species as well as their paired controls.
##### Levels: L.nina1 - L.nina7 (seven replicates for L. nina), Ypthimaspp.1 - Ypthimaspp.9 (nine replicates for Ypthima spp.).
#### 4. StartToFinish_cm: start to finish distance (in cm) flown by each individual butterfly and their paired control.
##### Start to finish distance flown was obtained by calculating the distance between first and last perching points of each of the observed butterflies and their 
###### paired controls using GPS coordinates (calculation from the "geosphere" package in R and converted to cm).
#### 5. PropOnVeg: the proportion of landing on vegetation of each individual butterfly and their paired control.
##### The proportion of landing on vegetation was obtained through comparisons with other types of actvities done by the observed individual butterflies
###### and their paired controls.
#### 6. SubstrateHeight_cm: the height of vegetation being landed on by each indvidual butterfly and their paired control (in cm).
##### The substrate height was measured by recording the height from the ground to where a disk (with a hole at its centre) fell. 
##### However, if the point fell on an individual substrate (e.g., an individual stick of vegetation, or a stack of oil palm dead fronds), we used a measuring
###### stick to directly record the height.



## 2. BtflyResourceRaw2
### Description: this file contains data used to run analysis on each individual butterfly and their paired control.
#### There are 15 columns consisting of observation on each individual butterfly as well as paired measurements on their paired control.
### Columns:
#### 1. PlantationCode: the code of each replicate of plantation types.
##### Levels: IM01-IM02, IP01-04, MM01-05.
###### IM01 = the first replicate of immature monoculture plantation, IP01 = the first replicate of immature polyculture,
###### MM01 = the first replicate of mature monoculture, and so on.
#### 2. PlantationType: the types of oil palm plantations assessed in this study.
##### Levels: 
###### 1. Immature monoculture, 
###### 2. Immature polyculture, 
###### 3. Mature monoculture.
#### 3. ButterflyID: contains info on the species/ genus of the observed butterflies.
##### Levels: 
###### 1. Leptosia.nina,
###### 2. Ypthima (For Ypthima, it is genus because the observed individuals might have consisted of more than one Ypthima species).
#### 4. ButterflyGroup: indicating the species of the observed butterfly.
##### Levels: 
###### 1. Leptosia.nina,
###### 2. Ypthima.spp.
#### 5. ButterflyReps: showing the replicates of each butterfly species as well as their paired controls.
##### Levels: L.nina1 - L.nina7 (seven replicates for L. nina), Ypthimaspp.1 - Ypthimaspp.9 (nine replicates for Ypthima spp.).
#### 6. StartToFinish_cm: start to finish distance (in cm) flown by each individual butterfly.
##### Start to finish distance flown was obtained by calculating the distance between first and last perching points of the observed butterflies using 
###### GPS coordinates (calculation from the "geosphere" package in R and converted to cm).
#### 7. SubstrateID: the identity of the substrate being landed on by the observed butterfly.
##### If the substrate was vegetation, identifications used Barnes & Chan (1990); Fee et al. (2017), Maizatul-Suriza & Idris (2012), Nobilly et al. (2021), 
###### and Ya'acob et al. (2022).
#### 8. SubstrateType: the type of the substrate being landed on by the observed butterfly.
##### Levels: 
###### 1. Broadleaved weed,
###### 2. Dead frond,
###### 3. Grass,
###### 4. Herb,
###### 5. Shrub.
#### 9. PropOnVeg: the proportion of landing on vegetation of each individual butterfly.
##### The proportion of landing on vegetation was obtained through comparisons with other types of actvities done by the observed individual butterflies.
#### 10. SubstrateHeight_cm: the height of vegetation being landed on by each indvidual butterfly.
##### The substrate height was measured by recording the height from the ground to where a disk (with a hole at its centre) fell. 
##### However, if the point fell on an individual substrate (e.g., an individual stick of vegetation, or a stack of oil palm dead fronds), we used a measuring
###### stick to directly record the height.
#### 11. ControlStartToFinish_cm: start to finish distance (in cm) of the paired control of each individual butterfly (in cm).
##### Start to finish distance flown was obtained by calculating the distance between first and last perching points of the paired controls of the individual 
###### butterflies using GPS coordinates (calculation from the "geosphere" package in R and converted to cm).
#### 12. ControlSubstrateID: the identity of the substrate being landed on of the paired control of each individual butterfly.
##### If the substrate was vegetation, identifications used Barnes & Chan (1990); Fee et al. (2017), Maizatul-Suriza & Idris (2012), Nobilly et al. (2021), 
###### and Ya'acob et al. (2022).
#### 13. ControlSubstrateType: the type of the substrate being landed on of the paired control of each individual butterfly.
##### Levels: 
###### 1. Bare ground,
###### 2. Broadleaved weed,
###### 3. Climber,
###### 4. Dead frond,
###### 5. Debris,
###### 6. Fern,
###### 7. Grass,
###### 8. Herb,
###### 9. NA (means data was not available),
###### 10. Tuber.
#### 14. ControlPropOnVeg: the proportion of landing on vegetation of the paired control of each individual butterfly.
##### Was obtained through comparisons with other types of actvities of the paired controls of the observed individual butterflies.
#### 15. ControlSubstrateHeight_cm: the height of vegetation being landed on of the paired control of each individual butterfly (in cm).
##### The substrate height was measured by recording the height from the ground to where a disk (with a hole at its centre) fell. 
##### However, if the point fell on an individual substrate (e.g., an individual stick of vegetation, or a stack of oil palm dead fronds), we used a measuring
###### stick to directly record the height. 



## 3. ButterflyResourceUse
### Description: this file contains all the data collected from the field, 
#### including those used to run the analysis on habitat structure and complexity and its effects on the observed butterflies.
#### There are 62 columns consisting of details of the study locations, its environmental conditions (representing habitat structure and complexity), 
##### as well as the observed butterflies.
### Columns:
#### 1. ResearcherName1: the name of the first researcher collecting data in the field.
#### 2. ResearcherName2: the name of the second researcher collecting data in the field.
#### 3. ResearcherName3: the name of the third researcher collecting data in the field.
#### 4. ResearcherName4: the name of the fourth researcher collecting data in the field.
#### 5. PlantationCode: the code of each replicate of plantation types.
##### Levels: IM01-IM02, IP01-04, MM01-05.
###### IM01 = the first replicate of immature monoculture plantation, IP01 = the first replicate of immature polyculture,
###### MM01 = the first replicate of mature monoculture, and so on.
#### 6. PlantationType: the types of oil palm plantations assessed in this study.
##### Levels: 
###### 1. Immature monoculture, 
###### 2. Immature polyculture, 
###### 3. Mature monoculture.
#### 7. Date_MMDDYYYY: the dates of data collection in the field (format: MMDDYYYY).
#### 8. Weather: the weather during data collection.
##### Levels: 
###### 1. NA (weather data not available), 
###### 2. Overcast, 
###### 3. Sunny.
#### 9. ObservationTimeStart: observation start time. Each observation on individual butterflies lasted for three minutes.
#### 10. TimeWindow: time window of observation.
##### Levels: 
###### 1. Afternoon, 
###### 2. Morning, 
###### 3. Noon.
#### 11. ButterflyID: the identity of the observed butterfflies.
##### Levels: 
###### 1. Leptosia nina, 
###### 2. Ypthima (any Ypthima species but not Y. baldus; identification could not be made to species levels because the butterflies were not caught),
###### 3. Ypthima baldus.
#### 12. ButterflyGroup: indicating the species of the observed butterfly.
##### Levels: 
###### 1. Leptosia.nina,
###### 2. Ypthima.spp. ("spp." because identification could not be made to species levels because the butterflies were not caught).
#### 13. ButterflyReps: showing the replicates of each butterfly species as well as their paired controls.
##### Levels: L.nina1 - L.nina7 (seven replicates for L. nina), Ypthimaspp.1 - Ypthimaspp.9 (nine replicates for Ypthima spp.).
#### 14. ButterflyActivity: showing the activities of the observed butterflies.
##### Levels: 
###### 1. Flying,
###### 2. NA (activity data not available),
###### 3. Nectaring,
###### 4. Resting,
###### 5. Sunning.
#### 15. ProportionFlying_seconds: the proportion of time spent flying during the 180 seconds (3 minutes) of observation on a butterfly.
#### 16. GPSPoint: ID for GPS coordinates of every stop where a butterfly made a perch.
#### 17. Easting: GPS coordinates (Easting) of every stop where a butterfly made a perch.
#### 18. Northing: GPS coordinates (Northing) of every stop where a butterfly made a perch.
#### 19. Distance_cm: distance between each stop made by the observed butterfly (in cm).
#### 20. TotalDistance_cm: sum of the distance travelled by each of the observed butterflies between perches during the three-minute observations (in cm). 
#### 21. Hops_numb: sums of hops made by the butterflies during the three-minute observations. 
#### 22. StartToFinish_cm: start to finish distance (in cm) flown by each individual butterfly.
##### Start to finish distance flown was obtained by calculating the distance between first and last perching points of the observed butterflies using 
###### GPS coordinates (calculation from the "geosphere" package in R and converted to cm).
#### 23. Bearing: bearing (direction of flight) between perches made by each of the observed butterflies, recorded using a compass.
#### 24. SubstrateID: the identity of the substrate being landed on by the observed butterfly.
##### If the substrate was vegetation, identifications used Barnes & Chan (1990); Fee et al. (2017), Maizatul-Suriza & Idris (2012), Nobilly et al. (2021), 
###### and Ya'acob et al. (2022).
#### 25. SubstrateType: the type of the substrate being landed on by the observed butterfly.
##### Levels: 
###### 1. Broadleaved weed,
###### 2. Dead frond,
###### 3. Grass,
###### 4. Herb,
###### 5. NA - means data was not available (NOTE: unlike the previous file, here there is an NA category due to this file containing the all data from the field (including raw data), while the second/ above file contains only data that was used for analysis),
###### 6. Shrub.
#### 26. SubstrateHeight_cm: the height of vegetation being landed on by each indvidual butterfly.
##### The substrate height was measured by recording the height from the ground to where a disk (with a hole at its centre) fell. 
##### However, if the point fell on an individual substrate (e.g., an individual stick of vegetation, or a stack of oil palm dead fronds), we used a measuring
###### stick to directly record the height.
#### 27. CanopyOpennes_N: canopy openness at north measured at 2.5m from each stop where a butterfly made a perch (measured using a densiometer).
#### 28. CanopyOpennes_S: canopy openness at south measured at 2.5m from each stop where a butterfly made a perch (measured using a densiometer).
#### 29. CanopyOpennes_E: canopy openness at east measured at 2.5m from each stop where a butterfly made a perch (measured using a densiometer).
#### 30. CanopyOpennes_W: canopy openness at west measured at 2.5m from each stop where a butterfly made a perch (measured using a densiometer).
#### 31. CanopyAverage_percent: the average percentage of canopy openness at a stop (where a butterfly made a perch) from all directions. 
#### 32. Fern: percentage coverage of fern at a stop where a butterfly made a perch (visually assessed).
#### 33. Grass: percentage coverage of grass at a stop where a butterfly made a perch (visually assessed).
#### 34. Herb: percentage coverage of herb at a stop where a butterfly made a perch (visually assessed).
#### 35. BareGround: percentage coverage of bare ground at a stop where a butterfly made a perch (visually assessed).
#### 36. OilPalmDeadFrond: percentage coverage of oil palm dead frond at a stop where a butterfly made a perch (visually assessed).
#### 37. Other: percentage coverage of other type of substrate (anything but not any of the previous categories) at a stop where a butterfly made a perch, 
##### (visually assessed).
#### 38. GroundCover_Total: total percentage coverage of understory vegetation and bare ground at a stop where a butterfly made a perch (visually assessed).
#### 39. Shelter: number of shelter at each stop where a butterfly made a perch.
##### Shelter was assessed by recording whether there was any substrate taller than waist height in the cardinal directions, north, east, south, west, 
###### and summing values to give a single shelter reading (0 if no shelter present, and 4 if all directions had a barrier).
#### 40. ControlGPS: ID for GPS coordinates of every stop of the paired control of a butterfly making a perch.
#### 41. ControlEasting: GPS coordinates (Easting) of every stop of the paired control of a butterfly making a perch.
#### 42. ControlNorthing: GPS coordinates (Northing) of every stop of the paired control of a butterfly making a perch.
#### 43. ControlStartToFinish_cm: start to finish distance (in cm) of the paired control of each individual butterfly (in cm).
##### Start to finish distance flown was obtained by calculating the distance between first and last perching points of the paired controls of the observed 
###### butterflies using GPS coordinates (calculation from the "geosphere" package in R and converted to cm).
#### 44. ControlBearing: bearing (direction of flight) between perches of the paired control of each of the observed butterflies,
##### randomly generated using https://www.random.org (Haahr, 2020).
#### 45. ControlSubstrateID: the identity of the substrate being landed on of the paired control of each individual butterfly.
##### If the substrate was vegetation, identifications used Barnes & Chan (1990); Fee et al. (2017), Maizatul-Suriza & Idris (2012), Nobilly et al. (2021), 
###### and Ya'acob et al. (2022).
#### 46. ControlSubstrateType: the type of the substrate being landed on of the paired control of each individual butterfly.
##### Levels: 
###### 1. Bare ground,
###### 2. Broadleaved weed,
###### 3. Climber,
###### 4. Dead frond,
###### 5. Debris,
###### 6. Fern,
###### 7. Grass,
###### 8. Herb,
###### 9. NA (means data was not available),
###### 10. Tuber.
#### 47. ControlSubstrateHeight_cm: the height of vegetation being landed on of the paired control of each individual butterfly (in cm).
##### The substrate height was measured by recording the height from the ground to where a disk (with a hole at its centre) fell. 
##### However, if the point fell on an individual substrate (e.g., an individual stick of vegetation, or a stack of oil palm dead fronds), we used a measuring
###### stick to directly record the height. 
#### 48. ControlCanopyOpenness_N: canopy openness at north measured at 2.5m from each stop of the paired control of a butterfly making a perch, 
##### (measured using a densiometer).
#### 49. ControlCanopyOpenness_S: canopy openness at south measured at 2.5m from each stop of the paired control of a butterfly making a perch, 
##### (measured using a densiometer).
#### 50. ControlCanopyOpenness_E: canopy openness at east measured at 2.5m from each stop of the paired control of a butterfly making a perch, 
##### (measured using a densiometer).
#### 51. ControlCanopyOpenness_W: canopy openness at west measured at 2.5m from each stop of the paired control of a butterfly making a perch, 
##### (measured using a densiometer).
#### 52. ControlCanopyAverage_percent: the average percentage of canopy openness at a stop of the paired control (of a butterfly making a perch), 
##### from all directions.
#### 53. Control_Fern: percentage coverage of fern at a stop of the paired control of a butterfly making a perch (visually assessed).
#### 54. Control_Grass: percentage coverage of grass at a stop of the paired control of a butterfly making a perch (visually assessed).
#### 55. Control_Herb: percentage coverage of herb at a stop of the paired control of a butterfly making a perch (visually assessed).
#### 56. Control_BareGround: percentage coverage of bare ground at a stop of the paired control of a butterfly making a perch (visually assessed).
#### 57. Control_OilPalmDeadFrond: percentage coverage of oil palm dead frond at a stop of the paired control of a butterfly making a perch (visually assessed).
#### 58. Control_Other: percentage coverage of other type of substrate (anything but not any of the previous categories) at a stop 
##### of the paired control of a butterfly making a perch (visually assessed).
#### 59. ControlGroundCover_Total: total percentage coverage of understory vegetation and bare ground at a stop of the paired control of a butterfly making a perch,
##### (visually assessed).
#### 60. ControlShelter: number of shelter at each stop of the paired control of a butterfly making a perch.
##### Shelter was assessed by recording whether there was any substrate taller than waist height in the cardinal directions, north, east, south, west, 
###### and summing values to give a single shelter reading (0 if no shelter present, and 4 if all directions had a barrier).
#### 61. SurveyNotes: notes of the field surveys.
#### 62. ButterflyNotes: notes on the observed butterflies.


# References

## Barnes, D.E. & Chan, L.G. (1990). Common weeds of Malaysia and their control. Ancom Berhad.

## Haahr, M. (2020). RANDOM.ORG - True random number service. https://www.random.org.

## Maizatul-Suriza, M. & Idris, A.S. (2012). Occurrence of common weeds in immature plantings of oil palm plantations in Malaysia. The Planter, 88(1037), 537-547.

## Nobilly, F., Atikah, S.N., Yahya, M.S., Jusoh, S., Cun, G.S., Norhisham, A.R., Tohiran, K.A., Zulkifli, R., & Azhar, B. (2021). Rotational cattle grazing
### improves understory vegetation biodiversity and structural complexity in oil palm plantations. Weed Biology and Management, 22(1), 13-26.

## Ya'acob, M.E., Lu, L., Nobilly, F., Che'Ya, N.N., Aziz, A.A., Dupraz, C., Yahya, M.S., Atikah, S.N. & Mamun, M.A.A. (2022). 
### Analysis of weed communities in solar farms located in tropical areas-the case of Malaysia. Agronomy, 12(12), 3073.



############################################### END OF META DATA #############################################################

