# HyP3 Tutorials

## Jupyter Notebooks

We provide step-by-step tutorials for using HyP3 programmatically via Jupyter Notebooks. 

* [Using the HyP3 Python SDK](https://nbviewer.jupyter.org/github/ASFHyP3/hyp3-sdk/blob/main/docs/sdk_example.ipynb "Using the HyP3 SDK Tutorial" ){target=_blank}
  -- This notebook walks through ordering and accessing RTC, InSAR, and autoRIFT products in Python using the HyP3 SDK.
* [Using the HyP3 SDK to search for jobs run by another user](https://nbviewer.jupyter.org/github/ASFHyP3/hyp3-sdk/blob/main/docs/search_other_user_jobs.ipynb "Using the HyP3 SDK to search for jobs run by another user" ){target=_blank}
  -- This notebook walks through using the HyP3 SDK to search for jobs run by another user.
* [Time series analysis with HyP3 and MintPy](https://nbviewer.org/github/ASFHyP3/hyp3-docs/blob/main/docs/tutorials/hyp3_insar_stack_for_ts_analysis.ipynb "Time series analysis with HyP3 and MintPy Tutorial" ){target=_blank}
  -- This notebook walks through performing a time-series analysis of the 2019 
  Ridgecrest, CA earthquake with HyP3 On Demand InSAR products and MintPy.


## StoryMaps

ASF provides a variety of interactive StoryMap tutorials focused on accessing and using
Synthetic Aperture Radar (SAR) data available from ASF. They can all be accessed here:

* [StoryMap Tutorials](https://asf-daac.maps.arcgis.com/home/index.html "StoryMap Tutorials" ){target=_blank}

The StoryMap collection includes step-by-step tutorials for ordering and accessing
[RTC](https://storymaps.arcgis.com/stories/2ead3222d2294d1fae1d11d3f98d7c35 "RTC On Demand StoryMap" ){target=_blank}
and [InSAR](https://storymaps.arcgis.com/stories/68a8a3253900411185ae9eb6bb5283d3 "InSAR On Demand StoryMap" ){target=_blank}
products in Vertex.

[![RTC On Demand Image](images/rtc-tutorial.png "Click to open RTC On Demand! tutorial")](https://storymaps.arcgis.com/stories/2ead3222d2294d1fae1d11d3f98d7c35 "RTC On Demand!" ){target=_blank}
[![InSAR On Demand Image](images/insar-tutorial.png "Click to open InSAR On Demand! tutorial")](https://storymaps.arcgis.com/stories/68a8a3253900411185ae9eb6bb5283d3 "InSAR On Demand!" ){target=_blank}
