# ASF HyP3

***Alaska Satellite Facility's Hybrid Pluggable Processing Pipeline***

HyP3 (pronounced *"hype"*) is a service for processing Synthetic Aperture Radar (SAR) imagery that addresses many common issues for users of
SAR data:

* Most SAR datasets require at least some processing to remove distortions before they are analysis-ready
* SAR processing is computing-intensive
* Software for SAR processing is complicated to use and/or prohibitively expensive
* Producing analysis-ready SAR data has a steep learning curve that acts as a barrier to entry

HyP3 solves these problems by providing a free service where people can request SAR processing on-demand. These
processing requests are picked up by automated systems, which handle the complexity of SAR processing on behalf of the
user. HyP3 doesn't require users to have a lot of knowledge of SAR processing before getting started; users only need to
submit the input data and set a few optional parameters if desired. With HyP3, analysis-ready products are just a few
clicks away.

## Getting started

{% include 'using-snippet.md' %}

## What's New

Follow [@ASFHyP3](https://twitter.com/ASFHyP3 "https://twitter.com/ASFHyP3" ){target=_blank} on Twitter, or check our [What's New](whats_new.md "HyP3 What's New" ){target=_blank} page to keep up to date on all things HyP3!

## Contact Us

{% include 'contact-snippet.md' %}
