# Contributing

Thank you for your interest in helping make custom on-demand SAR processing accessible!

We're excited you would like to contribute to HyP3! Whether you're finding bugs, 
adding new features, fixing anything broken, or improving documentation, get 
started by submitting an issue or pull request!

Please read our [Code of Conduct](CODE_OF_CONDUCT.md "HyP3 Code of Conduct" ){target=_blank} before contributing.

## Issues and Pull Requests are welcome

If you have any questions or ideas, or notice any problems or bugs, and want to open an issue, great!
We recommend first [searching our open issues](https://github.com/issues?q=is%3Aopen+is%3Aissue+org%3AASFHyP3 "https://github.com/issues" ){target=_blank}
to see if the issue has already been submitted (we may already be working on it!). If you think your 
issue is new, you're welcome to [create a new issue](https://github.com/ASFHyP3/ASFHyP3.github.io/issues/new "https://github.com/ASFHyP3/ASFHyP3.github.io/issues/new" ){target=_blank} in our
general issues tracker. If you know the specific [repository](https://github.com/orgs/ASFHyP3/repositories "https://github.com/orgs/ASFHyP3/repositories" ){target=_blank} that your issue pertains to, you can use its issues tracker.

Found a typo, know how to fix a bug, want to update the docs, want to add a new feature? Even better!
The smaller the PR, the easier it is to review and test, and the more likely it is to be successful.
For major contributions, consider opening an issue describing the contribution, so we can help guide
and breakup the work into digestible pieces.


### Pull Request Guidelines

We ask that you follow these guidelines with your contributions

#### Style

We generally follow python community standards ([PEP8](https://pep8.org/ "https://pep8.org/" ){target=_blank}), except we allow line
lengths up to 120 characters. We recommend trying to keep lines 80--100 characters long, but allow 
up to 120 when it improves readability.

#### Documentation

We are working to improve our documentation!

For all public-facing functions/methods (not
[marked internal use](https://www.python.org/dev/peps/pep-0008/#naming-conventions "https://www.python.org/dev/peps/pep-0008/#naming-conventions" ){target=_blank}),
please include [type hints](https://google.github.io/styleguide/pyguide.html#221-type-annotated-code "https://google.github.io/styleguide/pyguide.html#221-type-annotated-code" ){target=_blank}
(when reasonable) and a [docstring](https://www.python.org/dev/peps/pep-0257/ "https://www.python.org/dev/peps/pep-0257" ){target=_blank}
formatted [Google style](https://google.github.io/styleguide/pyguide.html#38-comments-and-docstrings "https://google.github.io/styleguide/pyguide.html#38-comments-and-docstrings" ){target=_blank}.

#### Tests

All of the automated tests for the project need to pass before your submission will be accepted.

If you add new functionality, please consider adding tests for that functionality as well.

#### Commits

* Make small commits that show the individual changes you are making
* Write descriptive commit messages that explain your changes

Example of a good commit message:
    
```
Improve contributing guidelines. Fixes #10

Improve contributing docs and consolidate them in the standard location
https://help.github.com/articles/setting-guidelines-for-repository-contributors/
```
