# Copyright (C) 2021 University of Glasgow
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import seaborn as sns

from ietfdata.rfcindex import *

ri = RFCIndex()

plt.rc('font',**{'family':'serif','serif':['Helvetica']})
plt.rc('axes', axisbelow=True)
plt.rcParams['pdf.fonttype'] = 42

data = {}

with open("data/errata-by-rfc.csv") as errataByRfcFile:
    errataByRfcFile.readline()
    for line in errataByRfcFile:
        line = line[:-1].split(',')
        rfc = line[0]
        area = line[1]
        errata_count = int(line[2])
        data[rfc] = (errata_count, area)

rfcs = sorted(data.keys(), key=lambda x: data[x], reverse=True)

with open("tables/top-rfcs-errata.tex", "w") as topErrataTable:

	print("""\\begin{table*}
\\centering
\\footnotesize
\\begin{tabular}{rlrrr}
\\toprule
\\textbf{RFC} & \\textbf{Title} & \\textbf{Year} & \\textbf{Area} & \\textbf{Filing count} \\\\
\\midrule""", file=topErrataTable)

	for rfc in rfcs[:10]:
		rfc_data = ri.rfc(rfc)
		print(f"{int(rfc[3:])} & {rfc_data.title} & {rfc_data.year} & {data[rfc][1]} & {data[rfc][0]} \\\\", file=topErrataTable)

	print("""\\bottomrule
\\end{tabular}
\\caption{Top 10 RFCs by errata filing count}
\\label{tab:top-10-rfcs-by-errata}
\\end{table*}""", file=topErrataTable)
