# Copyright (C) 2021 University of Glasgow
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions 
# are met:
# 
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

from dataclasses     import dataclass
from datetime        import datetime
from pathlib         import Path
from pavlova         import Pavlova
from pavlova.parsers import GenericParser
from typing          import List, Optional

import json

# ==================================================================================================

@dataclass
class RfcErratum:
	errata_id          : int
	doc_id             : str 
	errata_status_code : str
	errata_type_code   : str
	section            : str
	orig_text          : str
	correct_text       : str
	notes              : str
	submit_date        : datetime
	submitter_name     : str
	verifier_id        : int
	verifier_name      : str
	update_date        : Optional[datetime]

# --------------------------------------------------------------------------------------------------

class RfcErrata:
    errata : List[RfcErratum]
	
    def __init__(self):
        self.errata = []
        with open(Path("data", "errata.json")) as errataDataFile:
            for errata_json in json.load(errataDataFile):
                errata = Pavlova().from_mapping({k.replace("-", "_") : v for k, v in errata_json.items()}, RfcErratum)
                if errata.submit_date is None:
                    continue
                if errata.submit_date >= datetime.fromisoformat("2001-01-01") and errata.submit_date <= datetime.fromisoformat("2022-12-31"):
                    self.errata.append(errata)

