# Copyright (C) 2021 University of Glasgow
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

from ietfdata.rfcindex    import *
from rfcerrata            import *

ri = RFCIndex()
errata = RfcErrata().errata

status_rfc_counts = {}
stream_rfc_counts = {}
area_rfc_counts = {}

for rfc in ri.rfcs(until="2022-12"):
    status_rfc_counts[rfc.publ_status] = status_rfc_counts.get(rfc.publ_status, 0) + 1
    stream_rfc_counts[rfc.stream] = stream_rfc_counts.get(rfc.stream, 0) + 1
    area_rfc_counts[rfc.area] = area_rfc_counts.get(rfc.area, 0) + 1

errata_per_rfc = {}
stats_by_area = {"All": {}}
stats_by_stream = {"All": {}}
stats_by_status = {"All": {}}

area_pretty_print = {"art": "Applications and Real-Time (art)",
"gen": "General (gen)",
"int": "Internet (int)",
"ops": "Operations and Management (ops)",
"rtg": "Routing (rtg)",
"sec": "Security (sec)",
"tsv": "Transport (tsv)",
"rai": "Real-time Applications and Infrastructure (rai)",
"subip": "Sub-IP (subip)",
"app": "Applications (app)"}

for erratum in errata:
    if erratum.doc_id not in errata_per_rfc:
        errata_per_rfc[erratum.doc_id] = {}
    errata_per_rfc[erratum.doc_id][erratum.errata_type_code] = errata_per_rfc[erratum.doc_id].get(erratum.errata_type_code, 0) + 1
    errata_per_rfc[erratum.doc_id][erratum.errata_status_code] = errata_per_rfc[erratum.doc_id].get(erratum.errata_status_code, 0) + 1
    errata_per_rfc[erratum.doc_id]["All"] = errata_per_rfc[erratum.doc_id].get("All", 0) + 1

print(errata_per_rfc)
for rfc_id in errata_per_rfc:
    rfc = ri.rfc(rfc_id)
    if rfc.area not in stats_by_area:
        stats_by_area[rfc.area] = {}
    stats_by_area[rfc.area]["All"] = stats_by_area[rfc.area].get("All", 0) + errata_per_rfc[rfc_id]["All"]
    stats_by_area[rfc.area]["Technical"] = stats_by_area[rfc.area].get("Technical", 0) + errata_per_rfc[rfc_id].get("Technical", 0)
    stats_by_area[rfc.area]["Editorial"] = stats_by_area[rfc.area].get("Editorial", 0) + errata_per_rfc[rfc_id].get("Editorial", 0)
    stats_by_area[rfc.area]["Verified"] = stats_by_area[rfc.area].get("Verified", 0) + errata_per_rfc[rfc_id].get("Verified", 0)
    stats_by_area[rfc.area]["Held for Document Update"] = stats_by_area[rfc.area].get("Held for Document Update", 0) + errata_per_rfc[rfc_id].get("Held for Document Update", 0)
    stats_by_area[rfc.area]["Rejected"] = stats_by_area[rfc.area].get("Rejected", 0) + errata_per_rfc[rfc_id].get("Rejected", 0)
    stats_by_area[rfc.area]["Reported"] = stats_by_area[rfc.area].get("Reported", 0) + errata_per_rfc[rfc_id].get("Reported", 0)
    stats_by_area["All"]["All"] = stats_by_area["All"].get("All", 0) + errata_per_rfc[rfc_id]["All"]
    stats_by_area["All"]["Technical"] = stats_by_area["All"].get("Technical", 0) + errata_per_rfc[rfc_id].get("Technical", 0)
    stats_by_area["All"]["Editorial"] = stats_by_area["All"].get("Editorial", 0) + errata_per_rfc[rfc_id].get("Editorial", 0)
    stats_by_area["All"]["Verified"] = stats_by_area["All"].get("Verified", 0) + errata_per_rfc[rfc_id].get("Verified", 0)
    stats_by_area["All"]["Held for Document Update"] = stats_by_area["All"].get("Held for Document Update", 0) + errata_per_rfc[rfc_id].get("Held for Document Update", 0)
    stats_by_area["All"]["Rejected"] = stats_by_area["All"].get("Rejected", 0) + errata_per_rfc[rfc_id].get("Rejected", 0)
    stats_by_area["All"]["Reported"] = stats_by_area["All"].get("Reported", 0) + errata_per_rfc[rfc_id].get("Reported", 0)
    if rfc.stream not in stats_by_stream:
        stats_by_stream[rfc.stream] = {}
    stats_by_stream[rfc.stream]["All"] = stats_by_stream[rfc.stream].get("All", 0) + errata_per_rfc[rfc_id]["All"]
    stats_by_stream[rfc.stream]["Technical"] = stats_by_stream[rfc.stream].get("Technical", 0) + errata_per_rfc[rfc_id].get("Technical", 0)
    stats_by_stream[rfc.stream]["Editorial"] = stats_by_stream[rfc.stream].get("Editorial", 0) + errata_per_rfc[rfc_id].get("Editorial", 0)
    stats_by_stream[rfc.stream]["Verified"] = stats_by_stream[rfc.stream].get("Verified", 0) + errata_per_rfc[rfc_id].get("Verified", 0)
    stats_by_stream[rfc.stream]["Held for Document Update"] = stats_by_stream[rfc.stream].get("Held for Document Update", 0) + errata_per_rfc[rfc_id].get("Held for Document Update", 0)
    stats_by_stream[rfc.stream]["Rejected"] = stats_by_stream[rfc.stream].get("Rejected", 0) + errata_per_rfc[rfc_id].get("Rejected", 0)
    stats_by_stream[rfc.stream]["Reported"] = stats_by_stream[rfc.stream].get("Reported", 0) + errata_per_rfc[rfc_id].get("Reported", 0)
    stats_by_stream["All"]["All"] = stats_by_stream["All"].get("All", 0) + errata_per_rfc[rfc_id]["All"]
    stats_by_stream["All"]["Technical"] = stats_by_stream["All"].get("Technical", 0) + errata_per_rfc[rfc_id].get("Technical", 0)
    stats_by_stream["All"]["Editorial"] = stats_by_stream["All"].get("Editorial", 0) + errata_per_rfc[rfc_id].get("Editorial", 0)
    stats_by_stream["All"]["Verified"] = stats_by_stream["All"].get("Verified", 0) + errata_per_rfc[rfc_id].get("Verified", 0)
    stats_by_stream["All"]["Held for Document Update"] = stats_by_stream["All"].get("Held for Document Update", 0) + errata_per_rfc[rfc_id].get("Held for Document Update", 0)
    stats_by_stream["All"]["Rejected"] = stats_by_stream["All"].get("Rejected", 0) + errata_per_rfc[rfc_id].get("Rejected", 0)
    stats_by_stream["All"]["Reported"] = stats_by_stream["All"].get("Reported", 0) + errata_per_rfc[rfc_id].get("Reported", 0)

    if rfc.publ_status not in stats_by_status:
        stats_by_status[rfc.publ_status] = {}
    stats_by_status[rfc.publ_status]["All"] = stats_by_status[rfc.publ_status].get("All", 0) + errata_per_rfc[rfc_id]["All"]
    stats_by_status[rfc.publ_status]["Technical"] = stats_by_status[rfc.publ_status].get("Technical", 0) + errata_per_rfc[rfc_id].get("Technical", 0)
    stats_by_status[rfc.publ_status]["Editorial"] = stats_by_status[rfc.publ_status].get("Editorial", 0) + errata_per_rfc[rfc_id].get("Editorial", 0)
    stats_by_status[rfc.publ_status]["Verified"] = stats_by_status[rfc.publ_status].get("Verified", 0) + errata_per_rfc[rfc_id].get("Verified", 0)
    stats_by_status[rfc.publ_status]["Held for Document Update"] = stats_by_status[rfc.publ_status].get("Held for Document Update", 0) + errata_per_rfc[rfc_id].get("Held for Document Update", 0)
    stats_by_status[rfc.publ_status]["Rejected"] = stats_by_status[rfc.publ_status].get("Rejected", 0) + errata_per_rfc[rfc_id].get("Rejected", 0)
    stats_by_status[rfc.publ_status]["Reported"] = stats_by_status[rfc.publ_status].get("Reported", 0) + errata_per_rfc[rfc_id].get("Reported", 0)
    stats_by_status["All"]["All"] = stats_by_status["All"].get("All", 0) + errata_per_rfc[rfc_id]["All"]
    stats_by_status["All"]["Technical"] = stats_by_status["All"].get("Technical", 0) + errata_per_rfc[rfc_id].get("Technical", 0)
    stats_by_status["All"]["Editorial"] = stats_by_status["All"].get("Editorial", 0) + errata_per_rfc[rfc_id].get("Editorial", 0)
    stats_by_status["All"]["Verified"] = stats_by_status["All"].get("Verified", 0) + errata_per_rfc[rfc_id].get("Verified", 0)
    stats_by_status["All"]["Held for Document Update"] = stats_by_status["All"].get("Held for Document Update", 0) + errata_per_rfc[rfc_id].get("Held for Document Update", 0)
    stats_by_status["All"]["Rejected"] = stats_by_status["All"].get("Rejected", 0) + errata_per_rfc[rfc_id].get("Rejected", 0)
    stats_by_status["All"]["Reported"] = stats_by_status["All"].get("Reported", 0) + errata_per_rfc[rfc_id].get("Reported", 0)

with open("tables/errata-stats-area.tex", "w") as errataStats:
    print("""\\begin{table*}
\centering
\\footnotesize
\\begin{tabular}{lr|rrrr|rr}
\\toprule
\\textbf{Area} & \\textbf{\#} & \\textbf{Verified} & \\textbf{Held} & \\textbf{Rejected} & \\textbf{Reported} & \\textbf{Technical} & \\textbf{Editorial} \\\\
\\midrule""", file=errataStats)

    for area in stats_by_area:
        if area == "All":
            continue
        print(f"{area_pretty_print.get(area, area)} & {stats_by_area[area]['All']}  & {stats_by_area[area]['Verified']}  & {stats_by_area[area]['Held for Document Update']}  & {stats_by_area[area]['Rejected']}  & {stats_by_area[area]['Reported']}  & {stats_by_area[area]['Technical']}  & {stats_by_area[area]['Editorial']} \\\\", file=errataStats)

    print(f"\\midrule All & {stats_by_area['All']['All']}  & {stats_by_area['All']['Verified']}  & {stats_by_area['All']['Held for Document Update']}  & {stats_by_area['All']['Rejected']}  & {stats_by_area['All']['Reported']}  & {stats_by_area['All']['Technical']}  & {stats_by_area['All']['Editorial']} \\\\", file=errataStats)
    print("""\\bottomrule
\\end{tabular}
\\caption{Errata statistics by area.}
\\label{tab:errata-stats-area}
\\end{table*}""", file=errataStats)

with open("tables/errata-stats-stream.tex", "w") as errataStats:
    print("""\\begin{table*}
\centering
\\footnotesize
\\begin{tabular}{lr|rrrr|rr}
\\toprule
\\textbf{Stream} & \\textbf{\#} & \\textbf{Verified} & \\textbf{Held} & \\textbf{Rejected} & \\textbf{Reported} & \\textbf{Technical} & \\textbf{Editorial} \\\\
\\midrule""", file=errataStats)

    for stream in stats_by_stream:
        if stream == "All":
            continue
        if stream == "INDEPENDENT":
            stream_pretty = "Independent"
        else:
            stream_pretty = stream
        print(f"{stream_pretty} ({stream_rfc_counts[stream]}) & {stats_by_stream[stream]['All']}  & {stats_by_stream[stream]['Verified']}  & {stats_by_stream[stream]['Held for Document Update']}  & {stats_by_stream[stream]['Rejected']}  & {stats_by_stream[stream]['Reported']}  & {stats_by_stream[stream]['Technical']}  & {stats_by_stream[stream]['Editorial']} \\\\", file=errataStats)

    print(f"\\midrule All & {stats_by_stream['All']['All']}  & {stats_by_stream['All']['Verified']}  & {stats_by_stream['All']['Held for Document Update']}  & {stats_by_stream['All']['Rejected']}  & {stats_by_stream['All']['Reported']}  & {stats_by_stream['All']['Technical']}  & {stats_by_stream['All']['Editorial']} \\\\", file=errataStats)
    print("""\\bottomrule
\\end{tabular}
\\caption{Errata statistics by stream; the ``Editorial'' stream has no documents, and is not shown.}
\\label{tab:errata-stats-stream}
\\end{table*}""", file=errataStats)

with open("tables/errata-stats-status.tex", "w") as errataStats:
    print("""\\begin{table*}
\centering
\\footnotesize
\\begin{tabular}{lr|rrrr|rr}
\\toprule
\\textbf{Status} & \\textbf{\#} & \\textbf{Verified} & \\textbf{Held} & \\textbf{Rejected} & \\textbf{Reported} & \\textbf{Technical} & \\textbf{Editorial} \\\\
\\midrule""", file=errataStats)

    for status in stats_by_status:
        if status == "All":
            continue
        print(f"{status.title()} ({status_rfc_counts[status]}) & {stats_by_status[status]['All']}  & {stats_by_status[status]['Verified']}  & {stats_by_status[status]['Held for Document Update']}  & {stats_by_status[status]['Rejected']}  & {stats_by_status[status]['Reported']}  & {stats_by_status[status]['Technical']}  & {stats_by_status[status]['Editorial']} \\\\", file=errataStats)

    print(f"\\midrule All & {stats_by_status['All']['All']}  & {stats_by_status['All']['Verified']}  & {stats_by_status['All']['Held for Document Update']}  & {stats_by_status['All']['Rejected']}  & {stats_by_status['All']['Reported']}  & {stats_by_status['All']['Technical']}  & {stats_by_status['All']['Editorial']} \\\\",file=errataStats)
    print("""\\bottomrule
\\end{tabular}
\\caption{Errata statistics by status at publication.}
\\label{tab:errata-stats-status}
\\end{table*}""", file=errataStats)