import ietfdata.datatracker
from datetime import datetime
import numpy as np
import scipy.stats as sp
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import numpy as np
from matplotlib import pyplot as plt
import seaborn as sns
from cycler import cycler
import matplotlib.dates as mdates

dt = ietfdata.datatracker.DataTracker()

errata_pre_checker = []
errata_post_checker = []
errata_pre_checker_technical = []
errata_pre_checker_editorial = []
errata_post_checker_technical = []
errata_post_checker_editorial = []

errata_post_checker = []

errata_all = []

errata_all_technical = []
errata_all_editorial = []

errata_no_yang_doctor = []
errata_yang_doctor = []
errata_no_yang_doctor_technical = []
errata_no_yang_doctor_editorial = []
errata_yang_doctor_technical = []
errata_yang_doctor_editorial = []

errata_plot_all = []

with open("data/yang-rfc-stats.csv") as yangRfcStats:
    yangRfcStats.readline()
    for line in yangRfcStats:
        line = line.strip().split(",")
        draft = line[1][:line[1].rfind('-')]
        dt_draft = dt.document_from_draft(draft)
        latest_submission = None
        for submission in dt_draft.submissions:
            dt_submission = dt.submission(submission)
            if "posted" in dt_submission.state:
                if latest_submission is None or dt_submission.submission_date > latest_submission:
                    latest_submission = dt_submission.submission_date
        if latest_submission is not None and latest_submission > datetime(2016, 3, 5):
            errata_post_checker.append(int(line[3]))
            errata_post_checker_editorial.append(int(line[4]))
            errata_post_checker_technical.append(int(line[5]))
        else:
            errata_pre_checker.append(int(line[3]))
            errata_pre_checker_editorial.append(int(line[4]))
            errata_pre_checker_technical.append(int(line[5]))
        review_requests = list(dt.review_requests(doc=dt_draft))
        yang_doctored = False
        for review_request in review_requests:
            if "1970" in str(review_request.team) and "assigned" in str(review_request.state):
                yang_doctored = True
        if yang_doctored:
            errata_yang_doctor.append(int(line[3]))
            errata_yang_doctor_editorial.append(int(line[4]))
            errata_yang_doctor_technical.append(int(line[5]))
        else:
            errata_no_yang_doctor.append(int(line[3]))
            errata_no_yang_doctor_editorial.append(int(line[4]))
            errata_no_yang_doctor_technical.append(int(line[5]))
        errata_all.append(int(line[3]))
        errata_all_editorial.append(int(line[4]))
        errata_all_technical.append(int(line[5]))
        if latest_submission is not None:
            errata_plot_all.append((latest_submission, int(line[3]), yang_doctored, latest_submission is not None and latest_submission > datetime(2016, 3, 5)))

figsize = (6,3)

scatter_x_doctor = []
scatter_y_doctor = []
scatter_x_nodoctor = []
scatter_y_nodoctor = []

for plottable in errata_plot_all:
    if plottable[2]:
        scatter_x_doctor.append(plottable[0])
        scatter_y_doctor.append(plottable[1])
    else:
        scatter_x_nodoctor.append(plottable[0])
        scatter_y_nodoctor.append(plottable[1])

plt.rc('font',**{'family':'serif','serif':['Helvetica']})
plt.rc('axes', axisbelow=True)
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['font.size'] = 14

plt.figure(figsize=figsize)
plt.scatter(scatter_x_doctor, scatter_y_doctor, color="tab:orange", alpha=0.7, label="YANG Doctors review")
plt.scatter(scatter_x_nodoctor, scatter_y_nodoctor, color="tab:blue", alpha=0.7, label="No YANG Doctors review")

all_x_nums = mdates.date2num(scatter_x_doctor+scatter_x_nodoctor)
all_x = np.array(all_x_nums)
all_y = np.array(scatter_y_doctor + scatter_y_nodoctor)

a, b = np.polyfit(all_x, all_y, 1)
plt.plot(all_x, a*(all_x)+b, color="tab:gray") 

plt.xlabel("Final draft submission date")
plt.ylabel("Number of errata filings")
plt.ylim(-0.5, 9)
plt.legend()
plt.savefig('figures/yang-drafts.pdf', bbox_inches='tight')