import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import seaborn as sns
import numpy as np

plt.rc('font',**{'family':'serif','serif':['Helvetica']})
plt.rc('axes', axisbelow=True)
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['font.size'] = 10

sections = {}

with open("data/errata-location-sections.csv") as locationDataFile:
    locationDataFile.readline()
    for line in locationDataFile:
        line = line[:-1].split(",")
        sec_title = line[0]
        errata_type = line[1]
        if sec_title not in sections:
            sections[sec_title] = {"Technical": 0, "Editorial": 0, "Total": 0}
        sections[sec_title][errata_type] += 1
        sections[sec_title]["Total"] += 1

sorted_titles = sorted(sections.keys(), key=lambda name: sections[name]["Total"])
editorial = [sections[name]["Editorial"] for name in sorted_titles]
technical = [sections[name]["Technical"] for name in sorted_titles]

x = np.arange(len(sorted_titles))
plt.figure(figsize=(6,3))
plt.barh(x-0.2, technical, 0.4, label="Technical")
plt.barh(x+0.2, editorial, 0.4, label="Editorial")

plt.legend()
plt.yticks(np.arange(len(sorted_titles)), sorted_titles, rotation=30)
plt.xlabel("Number of errata")
plt.ylabel("Section name")

plt.savefig('figures/section-title-counts.pdf', bbox_inches='tight', metadata={'CreationDate': None})