import seaborn as sns
import matplotlib.pyplot as plt

sns.set_style('whitegrid')

plt.rc('font',**{'family':'serif','serif':['Helvetica']})
plt.rc('axes', axisbelow=True)
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['font.size'] = 14

data = {}

with open("data/email-discussion-outwg-emails.csv") as outwgFile:
    for line in outwgFile:
        line = line.strip().split(",")
        year = int(line[0])
        data[year] = [int(x) for x in line[1:]]
        
color_dict = {2007:"black",2012:"red",2017:"green",2022:"blue"}
linestyle_dict = {2007:"dashdot",2012:"dashed",2017:"dotted",2022:"solid"}

fig, ax_h = plt.subplots(figsize=(6,3))
#fig, ax_h = plt.subplots(figsize=(18,8))

for yr in [2007,2012,2017,2022]:
    sns.ecdfplot(data[yr], linewidth=2,ax=ax_h,label=str(yr-4)+'-'+str(yr),linestyle=linestyle_dict[yr])

ax_h.set_xlabel('Number of emails')
ax_h.set_ylabel('Proportion of errata submitters')
ax_h.set_xlim(-50,1000)

###
ax_h.set_xticks([0,100,200,300,400,500,600,700,800,900,1000])
ax_h.set_xticklabels([0,100,200,300,400,500,600,700,800,900,1000])#,rotation=90)#fontsize='x-large')
ax_h.set_yticks([0, 0.2,0.4,0.6,0.8,1])
ax_h.set_yticklabels([0, 0.2,0.4,0.6,0.8,1])
#plt.legend(fontsize='14', title_fontsize='14')

legend1 = plt.legend(loc="lower right")
#plt.setp(ax_h.get_legend().get_texts(), fontsize='16')
###

plt.savefig('figures/num_of_emails_outwg_CDF.pdf', bbox_inches='tight')