import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import seaborn as sns
import numpy as np

plt.rc('font',**{'family':'serif','serif':['Helvetica']})
plt.rc('axes', axisbelow=True)
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['font.size'] = 10

plt.rc('font',**{'family':'serif','serif':['Helvetica']})
plt.rc('axes', axisbelow=True)
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['font.size'] = 10

deciles = {}

with open("data/errata-location-percentiles.csv") as locationDataFile:
    locationDataFile.readline()
    for line in locationDataFile:
        line = line[:-1].split(",")
        decile = int(line[0])
        errata_type = line[1]
        if decile not in deciles:
            deciles[decile] = {"Technical": 0, "Editorial": 0}
        deciles[decile][errata_type] += 1

x = np.arange(len(deciles.keys()))# sorted(list(deciles.keys()))
editorial = [deciles[decile]["Editorial"] for decile in deciles]
technical = [deciles[decile]["Technical"] for decile in deciles]

plt.figure(figsize=(6,3))
plt.bar(x-0.2, technical, 0.4, label="Technical")
plt.bar(x+0.2, editorial, 0.4, label="Editorial")

plt.legend()
plt.xticks(np.arange(len(deciles)), list(deciles.keys()))
plt.xlabel("Percentage into document")
plt.ylabel("Number of errata")

plt.savefig('figures/location-percent.pdf', bbox_inches='tight', metadata={'CreationDate': None})