# Copyright (C) 2021 University of Glasgow
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

figsize = (6,3)

plt.rc('font',**{'family':'serif','serif':['Helvetica']})
plt.rc('axes', axisbelow=True)
plt.rcParams['pdf.fonttype'] = 42

years = []
data = {}
docs_year = {}
errata_by_area = {i : [] for i in range(11)}
docs_by_area = {i : [] for i in range(11)}

with open("data/errata-by-year.csv") as dataFile:
    dataFile.readline()
    for line in dataFile:
        line = line[:-1].split(',')
        year = int(line[0])
        docs = [int(doc_count) for doc_count in line[1:12]]
        errata = [float(errata_count) for errata_count in line[12:]]
        for i in range(len(errata)):
            errata_by_area[i].append(errata[i])
            docs_by_area[i].append(docs[i])
        if year not in years:
            years.append(year)

years = sorted(years)


plt.figure(figsize=figsize)
fig, axs = plt.subplots(2, sharex=True)
axs[1].set_xlabel("Year")
axs[1].set_ylabel("Number of errata per RFC")
axs[0].set_ylabel("Number of RFCs published")

areas = ["None","rtg","int","app","ops","sec","tsv","rai","gen","subip","art"]
base_count = [0]*len(docs_year)

#print(len(errata_by_area[0]), len(years))
#for area_i in errata_by_area:
#    axs[1].bar(years, errata_by_area[area_i], label=areas[area_i], bottom=base_count)
#    base_count = [base_count[i]+errata_by_area[area_i][i] for i in range(len(base_count))]
axs[1].stackplot(years, [errata_by_area[area_i] for area_i in range(len(errata_by_area))], labels=areas)
axs[0].stackplot(years, [docs_by_area[area_i] for area_i in range(len(docs_by_area))], labels=areas)

axs[0].legend(ncol=3, loc="upper left")

#axs[1].set_xticklabels(years, years, rotation=90)
axs[1].grid()
axs[0].grid()

plt.savefig('figures/errata-by-year.pdf', bbox_inches='tight', metadata={'CreationDate': None})
