# Copyright (C) 2021 University of Glasgow
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import seaborn as sns

import csv

plt.rc('font',**{'family':'serif','serif':['Helvetica']})
plt.rc('axes', axisbelow=True)
plt.rcParams['pdf.fonttype'] = 42

technical_1_10 = []
technical_11_20 = []
technical_21_above = []

#writer.writerow(["name", "filing_count", "technical", "editorial", "verified", "reported", "held_for_update", "rejected", "area_none", "area_int", "area_ops", "area_rai", "area_rtg", "area_app", "area_tsv", "area_gen", "area_sec", "area_art", "area_subip"])

with open("data/errata-by-submitter-alldata.csv") as errataBySubmitterFile:
    csv_reader = csv.reader(errataBySubmitterFile, delimiter=',')
    next(csv_reader)
    for row in csv_reader:
        name = row[0]
        filing_count = int(row[1])
        editorial = int(row[3])
        technical = int(row[2])
        if filing_count > 1 and filing_count <= 5:
            technical_1_10.append(technical/filing_count)
        elif filing_count > 5 and filing_count <= 10:
            technical_11_20.append(technical/filing_count)
        elif filing_count > 1:
            technical_21_above.append(technical/filing_count)

fig, ax = plt.subplots(figsize=(6,3))
sns.ecdfplot(technical_1_10,ax=ax,linewidth=2, label=f"2-5 filings ({len(technical_1_10)})")
sns.ecdfplot(technical_11_20,ax=ax,linewidth=2, label=f"6-10 filings ({len(technical_11_20)})")
sns.ecdfplot(technical_21_above,ax=ax,linewidth=2, label=f"11+ filings ({len(technical_21_above)})")

ax.set_xlabel('Proportion of errata filings that are technical')
ax.set_ylabel('Proportion of submitters')
plt.xlim(left = -0.1, right=1)
plt.legend()
plt.savefig('figures/errata-by-submitter-type.pdf', bbox_inches='tight', metadata={'CreationDate': None})
