# Copyright (C) 2021 University of Glasgow
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

figsize = (6,3)

plt.rc('font',**{'family':'serif','serif':['Helvetica']})
plt.rc('axes', axisbelow=True)
plt.rcParams['pdf.fonttype'] = 42

data = {}

with open("data/errata-by-status.csv") as dataFile:
    labels = dataFile.readline()[:-1].split(",")[3:]
    dataFile.readline()
    for line in dataFile:
        line = line[:-1].split(',')
        year = int(line[0])
        docs = int(line[1])
        errata_verified = int(line[2])
        errata_held = int(line[3])
        errata_rejected = int(line[4])
        errata_reported = int(line[5])
        data[year] = {"Verified": errata_verified, "Held for Document Update": errata_held, "Rejected": errata_rejected, "Reported": errata_reported}

years = sorted(data.keys())

plt.figure(figsize=figsize)
plt.xlabel("Year of RFC publication")
plt.ylabel("Number of errata")
plt.bar(years, [data[year]["Verified"] for year in years], label="Verified")
plt.bar(years, [data[year]["Held for Document Update"] for year in years], bottom=[data[year]["Verified"] for year in years], label="Held for Document Update")
plt.bar(years, [data[year]["Rejected"] for year in years], bottom=[data[year]["Verified"]+data[year]["Held for Document Update"] for year in years], label="Rejected")
plt.bar(years, [data[year]["Reported"] for year in years], bottom=[data[year]["Verified"]+data[year]["Held for Document Update"]+data[year]["Rejected"] for year in years], label="Reported")

#plt.xticks(years, rotation=90)
plt.grid()
plt.legend()
plt.savefig('figures/errata-by-status.pdf', bbox_inches='tight', metadata={'CreationDate': None})
