# Copyright (C) 2021 University of Glasgow
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import numpy as np
from matplotlib import pyplot as plt
import seaborn as sns

figsize = (6,3)

plt.rc('font',**{'family':'serif','serif':['Helvetica']})
plt.rc('axes', axisbelow=True)
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['font.size'] = 14

data = {"All": []}

all_errata = 0
all_count = 0

subip_errata = 0
subip_count = 0

app_errata = 0
app_count = 0

sec_errata = 0
sec_count = 0

with open("data/errata-by-rfc-by-area.csv") as dataFile:
    dataFile.readline()
    for line in dataFile:
        line = line[:-1].split(',')
        area = line[2]
        if area not in data:
            data[area] = []
        data[area].append(int(line[1]))
        data["All"].append(int(line[1]))
        if int(line[1]) != 0:
            all_errata += 1
        all_count += 1
        if area == "subip":
            subip_count += 1
            if int(line[1]) != 0:
                subip_errata += 1
        if area == "app":
            app_count += 1
            if int(line[1]) != 0:
                app_errata += 1
        if area == "sec":
            sec_count += 1
            if int(line[1]) != 0:
                sec_errata += 1

print(subip_errata, subip_count)
print(sec_errata, sec_count)
print(app_errata, app_count)
print(all_errata, all_count)

areas = sorted(data.keys(), key=lambda x: data[x])

plt.figure(figsize=figsize)
sns.ecdfplot(data = data["All"], label = "All", linestyle="dashed")
for area in areas:
    if area == "All":
        continue
    sns.ecdfplot(data = data[area], label = area)
plt.legend(ncol=2)
plt.xlabel("Number of errata")
plt.ylabel("Proportion of RFCs")
plt.xlim([-1, 10])
plt.savefig('figures/errata-by-rfc-by-area.pdf', bbox_inches='tight')