# Copyright (C) 2021 University of Glasgow
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

figsize = (6,3)

plt.rc('font',**{'family':'serif','serif':['Helvetica']})
plt.rc('axes', axisbelow=True)
plt.rcParams['pdf.fonttype'] = 42

data = {}

with open("data/errata-by-filing-year.csv") as dataFile:
    dataFile.readline()
    for line in dataFile:
        line = line[:-1].split(',')
        year = int(line[0])
        data[year] = int(line[1])

pid_data = {}

with open("data/pid_count_emailing_yearly.csv") as pidDataFile:
    pidDataFile.readline()
    for line in pidDataFile:
        line = line[:-1].split(",")
        year = int(line[0])
        pid_data[year] = int(line[1])

years = sorted(data.keys())

plt.figure(figsize=figsize)
fig, axs = plt.subplots(2, sharex=True)
axs[1].set_xlabel("Year")
axs[1].set_ylabel("Errata filings")
axs[0].set_ylabel("Number of Person IDs")

axs[1].bar(years, [data[year] for year in years])
axs[0].bar(years, [pid_data.get(year, 0) for year in years])
plt.xticks([2002, 2005, 2008, 2011, 2014, 2017, 2020], [2002, 2005, 2008, 2011, 2014, 2017, 2020])
axs[1].grid()
axs[0].grid()

plt.savefig('figures/errata-by-filing-year.pdf', bbox_inches='tight', metadata={'CreationDate': None})
