# Copyright (C) 2021 University of Glasgow
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import seaborn as sns
import numpy as np

plt.rc('font',**{'family':'serif','serif':['Helvetica']})
plt.rc('axes', axisbelow=True)
plt.rcParams['pdf.fonttype'] = 42

citation_counts_all = []
citation_counts = {}
errata_counts = {}
errata_counts_all = []

with open("data/errata-by-citation-count.csv") as errataByCitationCountFile:
    errataByCitationCountFile.readline()
    for line in errataByCitationCountFile:
        line = line[:-1].split(',')
        rfc = line[0]
        if rfc == "5741" or rfc == "4601":
            continue
        area = line[1]
        errata_count = int(line[2])
        citation_count = int(line[3])
        if area not in citation_counts:
            citation_counts[area] = []
            errata_counts[area] = []
        citation_counts[area].append(citation_count)
        errata_counts[area].append(errata_count)
        citation_counts_all.append(citation_count)
        errata_counts_all.append(errata_count)

fig, ax = plt.subplots(figsize=(6,3))

for area in citation_counts:
    plt.scatter(citation_counts[area], errata_counts[area], alpha=0.7, label=area)
plt.plot(np.unique(citation_counts_all), np.poly1d(np.polyfit(citation_counts_all, errata_counts_all, 1))(np.unique(citation_counts_all)))
ax.set_xlabel('Citation count')
ax.set_ylabel('Errata count')
plt.legend(ncol=4)

plt.savefig('figures/errata-by-citation-count.pdf', bbox_inches='tight', metadata={'CreationDate': None})
