import glob
import re
import ietfdata
import ietfdata.rfcindex
from rfcerrata import *

rfc_errata = RfcErrata()
rfc_index = ietfdata.rfcindex.RFCIndex()

rfc_txts = glob.glob("data/RFC-all/rfc*.txt")

rfc_yang = []

errata_by_rfc = {}
errata_by_id = {}

for erratum in rfc_errata.errata:
    errata_by_rfc[erratum.doc_id] = errata_by_rfc.get(erratum.doc_id, []) + [erratum.errata_id]
    errata_by_id[erratum.errata_id] = erratum
    
for rfc_txt in rfc_txts:
    try:
        with open(rfc_txt, encoding='utf-8') as rfcTxtFile:
            for line in rfcTxtFile:
                if re.search("module [^{]* {", line.strip()):
                    if rfc_txt not in rfc_yang:
                        rfc_yang.append(rfc_txt)
    except Exception as e:
        continue

month_dict = {"January":1,"February":2,"March":3,"April":4,"May":5,"June":6,"July":7,"August":8,"September":9,"October":10,"November":11,"December":12}

with open("data/yang-rfc-stats.csv", "w") as yangRfcStats:
    print(f"rfc_id,draft_that_became_rfc,errata_count,errata_within_two_years_of_pub,editorial_within_two_years_of_pub,technical_within_two_years_of_pub", file=yangRfcStats)
    for rfc_filename in rfc_yang:
        rfc_id = rfc_filename.strip("data/RFC-all/").strip(".txt").upper()
        rfc = rfc_index.rfc(rfc_id)
        if rfc.year <= 2020 and rfc.year >= 2001:
            errata_within_two_years_of_pub = []
            rfc_pub_datetime = datetime(rfc.year, month_dict[rfc.month], 1)
            for errata_id in errata_by_rfc.get(rfc_id, []):
                erratum = errata_by_id[errata_id]
                time_diff = erratum.submit_date - rfc_pub_datetime
                if time_diff.days <= 365*2:
                    errata_within_two_years_of_pub.append(errata_id)
            errata_types = [errata_by_id[errata_id].errata_type_code for errata_id in errata_within_two_years_of_pub]
            print(f"{rfc_id},{rfc.draft},{len(errata_by_rfc.get(rfc_id, []))},{len(errata_within_two_years_of_pub)},{errata_types.count('Editorial')},{errata_types.count('Technical')}", file=yangRfcStats)