# Copyright (C) 2020 University of Glasgow
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

import requests
import json
import re
from ietfdata import datatracker

import datetime

rfc_ids = {}
rfc_dates = {}
dt = datatracker.DataTracker()

with open("data/rfc_inbound_citations.csv", "w") as rfcInboundCitesFile:
    print(f"rfc_num,rfc_cited_by_count,citing_rfcs", file=rfcInboundCitesFile)
    with open("data/rfc_draft_stats.csv") as rfcIds:
        rfcIds.readline()
        for line in rfcIds:
            rfc = line[:-1].split(',')
            rfc_num = int(rfc[0])
            if rfc[1] == "None":
                continue
            ref_count = 0
            rfc_alias = list(dt.document_aliases(f"rfc{rfc_num}"))[0]
            related_docs = dt.related_documents(target=rfc_alias)
            cited_by = []
            for related_doc in related_docs:
                if "ref" in related_doc.relationship.uri:
                    ref_count += 1
                    source_doc = dt.document(related_doc.source)
                    if source_doc.rfc is not None:
                        cited_by.append(source_doc.rfc)
            cited_by_str = ",".join([str(rfc_cite) for rfc_cite in cited_by])
            print(f"{rfc_num},{len(cited_by)},{cited_by_str}", file=rfcInboundCitesFile)
