# Copyright (C) 2021 University of Glasgow
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

import os
import sys

sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))

from pathlib                  import Path
from ietfdata.datatracker     import *
from ietfdata.datatracker_ext import *
from ietfdata.rfcindex    import *

ri = RFCIndex()
dt = DataTrackerExt()

with open("data/rfc_draft_stats.csv", "w") as rfcDraftStatsFile:
    print("rfc_num,draft,stream,wg,area,year,updates_count,obsoletes_count,page_count,draft_count,earliest_draft,latest_draft,month,ref_count", file=rfcDraftStatsFile)

    for rfc in ri.rfcs():
       num = int(rfc.doc_id[3:])
       if rfc.year >= 2001 and rfc.year <= 2020:
           rfc_dt = rfc
           draft_count = 0
           earliest_date = None
           latest_date = None
           ref_count = 0
           if rfc_dt is not None:
               for d in dt.draft_history_for_rfc(rfc_dt):
                   draft_count += 1
                   if earliest_date is None or d.date < earliest_date:
                       earliest_date = d.date
                   if latest_date is None or d.date > latest_date:
                       latest_date = d.date
           related_docs = dt.related_documents(source=dt.document_from_rfc(rfc.doc_id))
           for related_doc in related_docs:
               if "ref" in related_doc.relationship.uri:
                   ref_count += 1
           print(f"{num},{rfc.draft},{rfc.stream},{rfc.wg},{rfc.area},{rfc.year},{len(rfc.updates)},{len(rfc.obsoletes)},{rfc.page_count},{draft_count},{earliest_date},{latest_date},{rfc.month},{ref_count}", file=rfcDraftStatsFile)