# Copyright (C) 2021 University of Glasgow
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions 
# are met:
# 
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

from ietfdata.rfcindex    import *
from rfcerrata            import *
from ietfdata.datatracker import *

ri = RFCIndex()
dt = DataTracker()

people_map = {}
people_emails = {}

doc_authors = {} 

with open("data/rfc_author_data.csv", "w") as authorDataFile:
    for rfc in ri.rfcs(until="2022-12"):
        doc_id = int(rfc.doc_id[3:])
        doc = dt.document_from_rfc(f"rfc{doc_id}")
        print(f"{rfc.doc_id},{len(rfc.authors)}", file=authorDataFile)
        doc_auths = dt.document_authors(doc)
        for author in doc_auths:
            if str(author.person.uri) in people_map:
                person = people_map[str(author.person.uri)]
                emails_for_person = people_emails[str(author.person.uri)]
            else:
                person = dt.person(author.person)
                people_map[str(author.person.uri)] = person
                people_emails[str(author.person.uri)] = []
                for email in dt.email_for_person(person):
                   if email.address not in people_emails[str(author.person.uri)]:
                    people_emails[str(author.person.uri)].append(email.address)
                for email in dt.email_history_for_person(person):
                    if email.address not in people_emails[str(author.person.uri)]:
                        people_emails[str(author.person.uri)].append(email.address)
            emails = ",".join(people_emails[str(author.person.uri)])
            print(f"{rfc.doc_id},{person.id},{emails}", file=authorDataFile)