import string
import sys
from dataclasses import dataclass, field
from ietfdata.datatracker import *
from ietfdata.mailarchive import *
import datetime
from datetime import datetime
from ietfdata.datatracker_ext import * #DataTrackerExt
import ietfdata.mailarchive2 as ma
import json

archive = ma.MailArchive()

dt      = DataTracker()

group_histories = list(dt.group_histories())
group_histories = group_histories + list(dt.groups())

group_list_mapping = {}

group_types = {}
group_states = {}
groups = {}

for group_type_name in dt.group_type_names():
    group_types[str(group_type_name.resource_uri)] = group_type_name.slug

for group_state in dt.group_states():
    group_states[str(group_state.resource_uri)] = group_state.slug

for group in dt.groups():
    groups[str(group.resource_uri)] = group

for group_history in group_histories:
    archive_url = group_history.list_archive.strip().strip("\u200b")
    if archive_url == "":
        continue
    list_url_regexes = [r'^(https?://mailarchive.ietf.org/arch/(browse/|search/\?email_list=))(?P<name>[^/]*)/?$',
                        r'^(https?://(www.)?ietf.org/mail-archive/web/)(?P<name>[^/]*)(/|$)',
                        r'^((ftp://)?ftp.ietf.org/ietf-mail-archive/)(?P<name>[^/]*)(/|$)',
                        r'^(https?://(www.)?ietf.org/mailman/(private|listinfo)/)(?P<name>[^/]*)(/|$)',
                        r'^(https?://(www.)?irtf.org/mail-archive/web/)(?P<name>[^/]*)(/|$)',
                        r'^(https?://(www.)?rfc-editor.org/pipermail/)(?P<name>[^/]*)(/|$)',
                        r'^(https?://ops.ietf.org/lists/)(?P<name>[^/]*)(/|$)']
    for list_url_regex in list_url_regexes:
        list_url_match = re.search(list_url_regex, archive_url)
        if list_url_match is not None:
            list_name = list_url_match.group("name").lower()
            group_list_mapping[list_name] = group_list_mapping.get(list_name, []) + [group_history]
            break

def label_mailing_list(mailing_list_name, at_date=None):
    mailing_list_name = mailing_list_name.lower()
    if mailing_list_name in group_list_mapping:
        group_histories = group_list_mapping[mailing_list_name]
        labels = []
        group_history = group_histories[-1]
        area = "None"
        if group_types[str(group_history.type)] == "wg":
            group_parent = group_history.parent
            while group_parent is not None:
                group_parent_group = dt.group(group_parent)
                if group_types[str(group_parent_group.type)] == "area":
                    area = group_parent_group.acronym
                    break
                else:
                    group_parent = group_parent_group.parent
        return (area, group_types[str(group_history.type)], group_states[str(group_history.state)])
    else:
        if re.match("(ietf)?\d+(attendees|all|onsite|companions?|hackathon|-mentees|-mentors|-1st-timers|-team)", mailing_list_name) is not None:
            return "meeting"
        elif re.match("nomcom\d+", mailing_list_name) is not None:
            return "nomcom"
    return None
    

maillist_yearly_monthly_type_active_status = dict()

for mailing_list_name in archive.mailing_list_names():
    type_response = label_mailing_list(mailing_list_name)#,datetime.strptime(date_, "%Y-%m-%d"))
    if isinstance(type_response, tuple):
        area_ = type_response[0]
        type_ = type_response[1]
        status_ = type_response[2]
    elif isinstance(type_response, str):
        area_ = 'None'
        type_ = type_response
        status_ = 'None'
    else:
        area_ = 'None'
        type_ = 'None'
        status_ = 'None'
    maillist_yearly_monthly_type_active_status[mailing_list_name] = {"area": area_, 'type':type_, 'status':status_}
        
json.dump(maillist_yearly_monthly_type_active_status, open( "data/maillist_area_type_status.json", 'w' ))
	