# Copyright (C) 2021 University of Glasgow
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions 
# are met:
# 
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

from ietfdata.rfcindex    import *
from rfcerrata            import *
from datetime             import datetime

ri = RFCIndex()
errata = RfcErrata().errata

errata_type = {}
errata_area = {}
times_to_file = {}

failed = 0

for erratum in errata:
	rfc = ri.rfc(erratum.doc_id)
	errata_area[erratum.errata_id] = rfc.area
	try:
		time_to_file = erratum.submit_date - datetime(rfc.year, datetime.strptime(rfc.month, "%B").month, 1)
		times_to_file[erratum.errata_id] = time_to_file.days
		errata_type[erratum.errata_id] = erratum.errata_type_code
	except Exception as e:
		print(e)
		failed = failed + 1
		
with open("data/errata-submission-dates-area.csv", "w") as timeToFileFile:
	print("errata_id,area,time_to_file", file=timeToFileFile)

	for errata_id in times_to_file.keys():
		print(f"{errata_id},{errata_area[errata_id]},{times_to_file[errata_id]},{errata_type[errata_id]}", file=timeToFileFile)