# Copyright (C) 2021 University of Glasgow
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions 
# are met:
# 
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

import csv

from ietfdata.datatracker    import *

dt = DataTracker()

people_aliases = {}

authors = []
non_authors = []

people_id_rfcs = {}

with open("data/people_aliases.csv") as peopleAliasesFile:
    for line in peopleAliasesFile:
        line = line[:-1].split(",")
        person_uri = line[0]
        alias = line[1]
        people_aliases[alias] = person_uri.split('/')[-2]

with open("data/rfc_author_data.csv") as rfcAuthorDataFile:
    for line in rfcAuthorDataFile:
        line = line[:-1].split(",")
        if len(line) > 2:
            rfc_id = line[0]
            person_id = line[1]
            if person_id not in people_id_rfcs:
                people_id_rfcs[person_id] = []
            if rfc_id not in people_id_rfcs[person_id]:
                people_id_rfcs[person_id].append(rfc_id)

count_no_dt = 0
count_dt = 0
count_dt_has_rfcs = 0

with open("data/errata-by-submitter-rfcs.csv", "w") as errataBySubmitterRfcsFile:
    csvwriter = csv.writer(errataBySubmitterRfcsFile)
    with open("data/errata-by-submitter-alldata.csv") as errataBySubmitterFile:
        csv_reader = csv.reader(errataBySubmitterFile, delimiter=',')
        next(csv_reader)
        for row in csv_reader:
            name = row[0]
            people_id = people_aliases.get(name, None)
            if people_id is not None:
                rfc_count = len(people_id_rfcs.get(people_id, []))
                count_dt += 1
                if rfc_count > 0:
                    count_dt_has_rfcs += 1
            else:
                count_no_dt += 1
                rfc_count = 0
            csvwriter.writerow([name, people_id, rfc_count])