# Copyright (C) 2021 University of Glasgow
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions 
# are met:
# 
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

from ietfdata.rfcindex    import *
from rfcerrata            import *

errata = RfcErrata().errata
ri = RFCIndex()

errata_by_area = {}
rfcs_cite_count = {}
rfc_errata_count = {}

with open("data/rfc_inbound_citations.csv") as citationsData:
    citationsData.readline()
    for line in citationsData:
        line = line.split(",")
        rfc_num = line[0]
        citation_count = int(line[1])
        rfcs_cite_count[rfc_num] = citation_count

for erratum in errata:
    doc_id = erratum.doc_id[3:]
    if doc_id not in rfc_errata_count:
        rfc_errata_count[doc_id] = 0
    rfc_errata_count[doc_id] += 1

with open("data/errata-by-citation-count.csv", "w") as errataByCitationCount:
    print("rfc,area,errata_count,cite_count", file=errataByCitationCount)

    for rfc in rfc_errata_count:
        if rfc not in rfcs_cite_count:
            continue
        print(f"{rfc},{ri.rfc(f'RFC{rfc}').area},{rfc_errata_count[rfc]},{rfcs_cite_count[rfc]}", file=errataByCitationCount)  