# Copyright (C) 2021 University of Glasgow
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions 
# are met:
# 
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

from ietfdata.rfcindex    import *
from rfcerrata            import *

ri = RFCIndex()
errata = RfcErrata().errata

errata_by_rfc = {}

docs_by_area_year = {}
docs_by_year = {}
errata_by_year = {}
areas = []

for erratum in errata:
	errata_by_rfc[erratum.doc_id] = errata_by_rfc.get(erratum.doc_id, 0) + 1

for rfc in ri.rfcs(until="2022-12"):
	docs_by_year[rfc.year] = docs_by_year.get(rfc.year, 0) + 1
	if rfc.year not in docs_by_area_year:
	    docs_by_area_year[rfc.year] = {}
	if rfc.area not in docs_by_area_year[rfc.year]:
	    docs_by_area_year[rfc.year][rfc.area] = 0
	docs_by_area_year[rfc.year][rfc.area] += 1
	if rfc.year not in errata_by_year:
	    errata_by_year[rfc.year] = {}
	if rfc.area not in errata_by_year[rfc.year]:
	    errata_by_year[rfc.year][rfc.area] = 0
	errata_by_year[rfc.year][rfc.area] = errata_by_year[rfc.year][rfc.area] + errata_by_rfc.get(rfc.doc_id, 0)
	if rfc.area not in areas:
	    areas.append(rfc.area)

with open("data/errata-by-year.csv", "w") as errataByYearFile:
	print(f"year,{',docs_'.join([str(area) for area in areas])},{',errata_'.join([str(area) for area in areas])}", file=errataByYearFile)

	for year in sorted(docs_by_year.keys()):
		area_counts = [str(errata_by_year[year].get(area, 0)/docs_by_year[year]) for area in areas]
		doc_counts = [str(docs_by_area_year[year].get(area, 0)) for area in areas]
		print(f"{year},{','.join(doc_counts)},{','.join(area_counts)}", file=errataByYearFile)