# Copyright (C) 2021 University of Glasgow
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions 
# are met:
# 
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

from ietfdata.rfcindex    import *
from rfcerrata            import *
import csv

ri = RFCIndex()
errata = RfcErrata().errata

submitter_ids = []
errata_by_submitter = {}

for erratum in errata:
	if erratum.submitter_name not in submitter_ids:
		submitter_ids.append(erratum.submitter_name)
	submitter_id = erratum.submitter_name.lower()
	errata_by_submitter[submitter_id] = errata_by_submitter.get(submitter_id, 0) + 1

errataBySubmitterFile = open('data/errata-by-submitter.csv', 'w')
writer = csv.writer(errataBySubmitterFile)

writer.writerow(["name", "filing_count"])

# close the file

for name in errata_by_submitter.keys():
	writer.writerow([name, errata_by_submitter[name]])
		
errataBySubmitterFile.close()
