# Copyright (C) 2021 University of Glasgow
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions 
# are met:
# 
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

from ietfdata.rfcindex    import *
from rfcerrata            import *
import csv

ri = RFCIndex()
errata = RfcErrata().errata

submitter_ids = []
errata_by_submitter = {}

for erratum in errata:
	if erratum.submitter_name not in submitter_ids:
		submitter_ids.append(erratum.submitter_name)
	submitter_id = erratum.submitter_name.lower()
	if submitter_id not in errata_by_submitter:
	    errata_by_submitter[submitter_id] = {"total": 0, "Technical": 0, "Editorial": 0, "Verified": 0, "Reported": 0, "Held for Document Update": 0, "Rejected": 0, None: 0, "int": 0, "ops": 0, "rai": 0, "rtg": 0, "app": 0, "tsv": 0, "gen": 0, "sec": 0, "art": 0, "subip": 0}
	errata_by_submitter[submitter_id]["total"] = errata_by_submitter[submitter_id]["total"] + 1
	errata_by_submitter[submitter_id][erratum.errata_type_code] = errata_by_submitter[submitter_id][erratum.errata_type_code] + 1
	errata_by_submitter[submitter_id][erratum.errata_status_code] = errata_by_submitter[submitter_id][erratum.errata_status_code] + 1
	rfc = ri.rfc(erratum.doc_id)
	errata_by_submitter[submitter_id][rfc.area] = errata_by_submitter[submitter_id][rfc.area] + 1

	
errataBySubmitterFile = open('data/errata-by-submitter-alldata.csv', 'w')
writer = csv.writer(errataBySubmitterFile)

writer.writerow(["name", "filing_count", "technical", "editorial", "verified", "reported", "held_for_update", "rejected", "area_none", "area_int", "area_ops", "area_rai", "area_rtg", "area_app", "area_tsv", "area_gen", "area_sec", "area_art", "area_subip"])

# close the file

for name in errata_by_submitter.keys():
	writer.writerow([name, errata_by_submitter[name]["total"], errata_by_submitter[name]["Technical"], errata_by_submitter[name]["Editorial"], errata_by_submitter[name]["Verified"], errata_by_submitter[name]["Reported"], errata_by_submitter[name]["Held for Document Update"], errata_by_submitter[name]["Rejected"], errata_by_submitter[name][None], errata_by_submitter[name]["int"], errata_by_submitter[name]["ops"], errata_by_submitter[name]["rai"], errata_by_submitter[name]["rtg"], errata_by_submitter[name]["app"], errata_by_submitter[name]["tsv"], errata_by_submitter[name]["gen"], errata_by_submitter[name]["sec"], errata_by_submitter[name]["art"], errata_by_submitter[name]["subip"]])
		
errataBySubmitterFile.close()
