# Copyright (C) 2021 University of Glasgow
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions 
# are met:
# 
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

from ietfdata.rfcindex    import *
from rfcerrata            import *

ri = RFCIndex()
errata = RfcErrata().errata

errata_by_rfc = {}

docs_by_year = {}
errata_by_year = {}

status_codes = []

for erratum in errata:
	if erratum.errata_status_code not in status_codes:
		status_codes.append(erratum.errata_status_code)
	if erratum.doc_id not in errata_by_rfc:
		errata_by_rfc[erratum.doc_id] = {}
	if erratum.errata_status_code not in errata_by_rfc[erratum.doc_id]:
		errata_by_rfc[erratum.doc_id][erratum.errata_status_code] = 0
	errata_by_rfc[erratum.doc_id][erratum.errata_status_code] += 1

for rfc in ri.rfcs(until="2022-12"):
	docs_by_year[rfc.year] = docs_by_year.get(rfc.year, 0) + 1
	if rfc.year not in errata_by_year:
		errata_by_year[rfc.year] = {status_code : 0 for status_code in status_codes}
	if rfc.doc_id in errata_by_rfc:
		for status_code in status_codes:
			errata_by_year[rfc.year][status_code] += errata_by_rfc[rfc.doc_id].get(status_code, 0)
	
with open("data/errata-by-status.csv", "w") as errataByYearFile:
	status_code_pretty = ",".join(status_codes)
	print(f"year,doc_count,errata_count,{status_code_pretty}", file=errataByYearFile)

	for year in docs_by_year.keys():
		status_code_pretty_values = ",".join([str(errata_by_year[year][status_code]) for status_code in status_codes])
		print(f"{year},{docs_by_year[year]},{status_code_pretty_values}", file=errataByYearFile)