# Copyright (C) 2020 University of Glasgow
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

import pandas as pd
import os
import sys
import csv
import time

sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))

from pathlib import Path
from ietfdata.datatracker import *
from ietfdata.datatracker_ext import *

# =============================================================================
# Example: print information about a person

#dt = DataTracker(cache_dir=Path("cache"))
dt = DataTracker()
dte = DataTrackerExt()

colnames = ['Email','Name_In_Archive']

fline = 'data/overall_email_unique.csv'

with open('data/overall_email_uri_mapping.csv', 'w', encoding='utf8') as wfile:

    writer = csv.writer(wfile, delimiter='\t', quotechar=None)
    df = pd.read_csv(fline, delimiter='\t', header=0, names=colnames)

    for index, row in df.iterrows():
        print(row)
        # p = dt.person_from_email("csp@csperkins.org")
        # p = dt.person_from_email("schulzrinne@cs.columbia.edu")

        p_email = row['Email']
        p_email_primary = ''
        p_emails = ''
        p_uri = ''
        p_alias = ''
        p_name = ''
        p_ascii_name = ''
        p_draft_name = ''
        p_id = ''

        try:
            #p = dt.person_from_email(row['Email'])
            # replace above with DataTrackerExt()

            p = dte.person_from_name_email(row['Name_In_Archive'],row['Email'])

            if p is not None:
            	
                p_uri = p.resource_uri.uri

                # print("Name: {}".format(p.name))
                # print("Biography: {}".format(p.biography))
                p_name = p.name
                p_draft_name = p.name_from_draft
                p_ascii_name = p.ascii
                p_id = p.id

                for alias in dt.person_aliases(p):
                    # print("Known as: {}".format(alias.name))
                    p_alias = p_alias + ';' + alias.name

                for email in dt.email_for_person(p):
                    if email.primary:
                        primary = "(primary)"
                        p_email_primary = email.address
                    else:
                        primary = ""
                    p_emails = p_emails + ';' + email.address
                # print("Email: {} {}".format(email.address, primary))
                writer.writerow([p_email.lower(), p_uri.lower(), int(p_id), p_email_primary.lower(),p_emails.lower(), p_name, p_ascii_name, p_draft_name, p_alias])
                print(index, p_email, p.resource_uri.uri)

            else:
                print(index, 'p NONE', p_email.lower())
                writer.writerow([p_email.lower(), p_uri.lower(), p_id, p_email_primary.lower(),p_emails.lower(), p_name, p_ascii_name, p_draft_name, p_alias])
            
        except:
            print(index, 'p AttributeError NONE', p_email.lower())
            writer.writerow([p_email.lower(), p_uri.lower(), p_id, p_email_primary.lower(),
                             p_emails.lower(), p_name, p_ascii_name, p_draft_name, p_alias])
