#!/bin/bash
# Clean up the intermediate IMP results.

# Attention:
# Make sure the IMP is NOT running while using this script!!!!


# Load necessary modules for propti (with sceua from SPOTPY) and FDS.
module use -a /beegfs/larnold/modules
module load python_common_modules/py3.9_2021.09.05
module load mpi4py/py3.9_IMPI-2021.2_3.1.3
module load spotpy/1.5.14
module load FDS/6.7.6_810_IntelComp_IntelMPI.2021.2


# Get restart markers.
grep "Restart" propti_db.csv


# Remove the propti_db backup.
rm Analysis/Databases/propti_db_original.csv

# Clean the propti_db.
python3 ../../../propti/propti_analyse.py --clean_db .

# Extract the best parameter set per generation.
python3 ../../../propti/propti_analyse.py --extract_data .

# Create the simulation input file with the best parameter set.
python3 ../../../propti/propti_analyse.py --create_best_input .

# Dump plots to get an overview over the inverse modelling process.
python3 ../../../propti/propti_analyse.py --dump_plots .


# Script finished.
echo "* IMP results processed. ", `hostname`, `date`
