#!/usr/bin/sh

env -i bash -l -c "
echo '* Prepare running FDS'

echo '* Loading modules'

module use -a /beegfs/larnold/modules/FDS
#module load FDS/6.7.6_810_IntelComp_IntelMPI.2021.2
module load FDS/6.7.9_IntelComp_IntelMPI.2021.2
#module load FDS/6.7.9_IntelComp_IntelMPI.2021.2_noIntelModules


echo '* FDS version loaded:'
which fds

if [ \"$#\" -eq 0 ]; then
    echo | OMP_NUM_THREADS=1 fds
else
    OMP_NUM_THREADS=1 fds $1
    wct=\`grep 'Total Elapsed Wall Clock Time' *.out | cut -d: -f2\`
    hostname=`hostname`
    dir=${PWD##*}
    date=\`date\`
    echo \"`date`; `hostname`; \`grep 'Total Elapsed Wall Clock Time' *.out | cut -d: -f2\`; `pwd` \"  > wct.csv
fi
"

sleep 5

