## Experimental Measurements for Pyrolysis Model Validation - Anaerobic Gasification of PMMA Under External Thermal Radiation


### Test Overview

A set of  16 anaerobic gasification experiments was conducted on the poly(methyl methacrylate), PMMA, that was made available to participants in the MaCFP-2 Workshop. In each test, samples (i.e., PMMA discs of approximate dimensions: 7 cm diameter, 5.8 mm thickness) were exposed to radiant heating (nominally 25 kW m<sup>-2</sup> or 50 kW m<sup>-2</sup> across their top surface) in an anaerobic environment. Samples were insulated at their back surface and continuously heated until complete decomposition was observed. Test boundary conditions (e.g., time- and spatially-resolved measurements of incident radiant heat flux; chamber wall temperatures) were carefully characterized, as described below.

#### Measurement data obtained in this test series includes:
1. Time-resolved measurements of PMMA sample mass [g];
2. Time-resolved measurements of PMMA back surface temperature [K];
3. Photographs and video of PMMMA decomposition behavior;
4. Time-resolved measurements of temperature rise [K] of inert materials (Copper, Kaowool PM insulation board);

### Pyrolysis Model Validation Exercise (Spring/Summer 2023)
In preparation for the MaCFP-3 Workshop (Oct. 2023), a pyrolysis model validation exercise has been defined (deadline to submit results, June 1, 2023) to identify the most accurate material property set(s) for use in MaCFP-3 fire growth simulation.

* **Validation Exercise:** Participants who submitted pyrolysis models (i.e., material property sets for MaCFP PMMA) to the MaCFP-2 Workshop are asked to use their original model parameters to predict (without adjustment to material properties) the results of the NIST-Gasification-Apparatus validation experiments.
* **(Re)Calibration Exercise:** If sufficient agreement is not observed, modelers are asked to recalibrate their property sets (new models are also welcomed). 
    *  Modelers MUST use independent model calibration and model validation datasets: pyrolysis models shall not be directly calibrated to new validation data
    * New submissions (material property sets) must include:
        * Descriptions of what data sets and what methods were used for model calibration
        * Final property set (degradation reaction mechanism & kinetics, thermodynamic properties, and transport properties) [link to guidelines document]
        * Predictions (numerical simulations) of validation experiments



Further details are available online in the [Modeling Guidelines Wiki](https://github.com/MaCFP/macfp-db/wiki/MaCFP-2023-Modeling-Guidelines#additional-guidelines-for-nist-gasification-apparatus).