# Poly(methyl methacrylate), PMMA

This folder holds measurement data, calibrated material property datasets, and results of numerical simulations related to the pyrolysis of case black PMMA. The specific material of interest is a nominally 6 mm (0.236 inch) thick, black, cast PMMA manufactured by Evonik under the tradename: ACRYLITE cast black 9H01 GT. Note: the identification of any commercial product or trade name does not imply endorsement or recommendation by the National Institute of Standards and Technology, NIST (or any other contributing institution).

|Folder Name| Description|
|---|---|
|Calibration_Data| Experimental measurements (e.g., TGA, DSC, Cone Calorimeter) used for pyrolysis model calibration (i.e., material property determination)|
|Calibration_Results|Results of numerical simulations demonstrating the ability of proposed material property sets to accurately *reproduce* relevant model calibration data|
|Computational_Results|Model predictions of sample decomposition in response to idealized zero- and one-dimensional heating scenarios (used for model to model comparison)|
|Material_Properties|Pyrolysis models (i.e., material property sets) organized in a standard .json format|
|Validation_Data|Experimental Measurements (sample mass loss and back surface temperature rise during anaerobic gasification of PMMA under external thermal radiation) for Pyrolysis Model Validation |
|Validation_Results|Results of numerical simulations demonstrating the ability of proposed material property sets to *predict* measured material decomposition behavior (used for model validation)|