# University of Lille - ENSCL - Unite Materiaux et Transformations (UMET)

### Experimental Conditions, TGA

* Heating Rates: 1, 2, 5, 10, 20, 50, and 100 K/min
* Temperature program
  - Initial Temperature: 313.15 K
  - Initial Isotherm: None
  - Maximum Temperature: 1273.15 K
  - Final Isotherm: None
* Sample mass: 3.93 – 5.98 mg
* Sample geometry: powdered
* Calibration type: Temperature calibration was performed every 6 months using a set of 5 reference materials with melting temperatures between 156.6 - 660 C
* Crucible
  - Type: Al2O3
  - Volume: 85 µL
  - Diameter: None
  - Mass: None
  - Lid: None
  - Note: None
* Carrier Gas
  - Type: Nitrogen
  - Flow rate: 40 ml/min
  - Note: Nitrogen (Vacuuming and filling according to the desired atmosphere)
* Instrument
  - Type: Netzsch TG 209 Libra
  - Note: None


|Test Name | Heating Rate (K/min) | Initial Sample Mass (mg)|  
|----------|:------:|  :------:| 
|UMET\_TGA\_N2\_1K\_1 | 1 | 4.336 |
|UMET\_TGA\_N2\_2K\_1 | 2 | 4.845 |
|UMET\_TGA\_N2\_5K\_1 | 5 | 4.093 |
|UMET\_TGA\_N2\_10K\_1 | 10 | 5.339  |
|UMET\_TGA\_N2\_20K\_1 | 20 | 3.929  |
|UMET\_TGA\_N2\_50K\_1 | 50 | 5.980 |
|UMET\_TGA\_N2\_100K\_1 | 100 | 5.364 |

NOTE: TGA time data was reported as [s] but appeared to be in units of [min]. Values were scaled by a factor of 60, accordingly.
### Experimental Conditions, DSC

* Measurement of cp was made by comparison with sapphire and using modulation
* Heating Rates: 3, 10, 20 K/min
* Temperature program
  - Initial temperature 243.15 K
  - Maximum Temperature 433.15 K
* Sample mass: ~5 mg
* Sample geometry: powdered
* Calibration type: Cp, enthalpy, melting point; calibration was performed every 6 months using sapphire (Cp) and Indium (enthalpy, melting point)
* Crucible type: Aluminum
* Carrier Gas
  - Nitrogen 
  - Flow rate = 50 ml/min
* Instrument type: Discovery TA


|Test Name | Heating Rate (K/min) | 
|----------|:------:|  
|UMET\_DSC\_N2\_3K\_1 | 3 | 
|UMET\_DSC\_N2\_10K\_1 | 10 |
|UMET\_DSC\_N2\_10K\_2 | 10 |
|UMET\_DSC\_N2\_20K\_1 | 20 |
|UMET\_DSC\_N2\_20K\_2 | 20 |

### Diffusivity (LFA 467 Hyperflash- Netzsch):
* Laser flash analysis
* 3 flash for each temperature
* Square sample 25.4*25.4cm²
* Both sides of the sample coated with graphite paint

### Conductivity (TPS 2500S-Hot Disk):
* Transient Plane Source (TPS) method
* Kapton sensor (radius 2.0mm)
* Ambient temperature measurement
* 2 plates for measurement
* Isotropic material
* The material is considered as semi-infinite when using the appropriate size of the sensor.
* Energy pulse:
  - Power: 35 mW
  - Duration: 20 s
